







use crate::imp_prelude::*;

#[cfg(target_has_atomic = "ptr")]
use alloc::sync::Arc;

#[cfg(not(target_has_atomic = "ptr"))]
use portable_atomic_util::Arc;




impl<A, D> ArcArray<A, D>
where D: Dimension
{


    pub fn is_unique(&self) -> bool
    {

        Arc::strong_count(&self.data.0) == 1
    }
}
