% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xportr-package.R
\docType{package}
\name{xportr-package}
\alias{xportr-package}
\title{The \code{xportr} package}
\description{
\code{xportr} is designed to be a clinical workflow friendly method for outputting
CDISC complaint data sets in R, to XPT version 5 files. It was designed with
options in mind to allow for flexible setting of options while allowing
projects and system administrators to set sensible defaults for their
organizations workflows. Below are a list of options that can be set to
customize how \code{xportr} works in your environment.
}
\section{xportr options}{


\itemize{
\item{
xportr.df_domain_name - The name of the domain "name" column in dataset
metadata. Default: \code{"dataset"}
}
\item {
xportr.df_label - The column noting the dataset label in dataset metadata.
Default: \code{"label"}
}
\item{
xportr.domain_name - The name of the domain "name" column in variable
metadata. Default: \code{"dataset"}
}
\item{
xportr.variable_name - The name of the variable "name" in variable
metadata. Default: \code{"variable"}
}
\item{
xportr.type_name - The name of the variable type column in variable
metadata. Default: \code{"type"}
}
\item{
xportr.label - The name of the variable label column in variable metadata.
Default: \code{"label"}
}
\item{
xportr.length - The name of the variable length column in variable
metadata. Default: \code{"length"}
}
\item{
xportr.order_name - The name of the variable order column in variable
metadata. Default: \code{"order"}
}
\item{
xportr.format_name - The name of the variable format column in variable
metadata. Default: \code{"format"}
}
\item{
xportr.format_verbose - The default argument for the 'verbose' argument for
\code{xportr_format}. Default: \code{"none"}
}
\item{
xportr.label_verbose - The default argument for the 'verbose' argument for
\code{xportr_label}. Default: \code{"none"}
}
\item{
xportr.length_verbose - The default argument for the 'verbose' argument for
\code{xportr_length}. Default: \code{"none"}
}
\item{
xportr.type_verbose - The default argument for the 'verbose' argument for
\code{xportr_type}. Default: \code{"none"}
}
\item{
xportr.character_types - The default character vector used to explicitly
coerce R classes to character XPT types. Default: \code{"character"}
}
\item{
xportr.character_metadata_types - The default character vector used to explicitly
coerce R classes to character XPT types. Default: \code{c("character", "char", "text", "date", "posixct", "posixt", "datetime", "time", "partialdate", "partialtime", "partialdatetime", "incompletedatetime", "durationdatetime", "intervaldatetime")}
}
\item{
xportr.numeric_metadata_types - The default character vector used to explicitly
coerce R classes to numeric XPT types. Default: \code{c("integer", "numeric", "num", "float")}
}
\item{
xportr.numeric_types - The default character vector used to explicitly
coerce R classes to numeric XPT types. Default:
\code{c("integer", "float", "numeric", "posixct", "posixt", "time", "date", "hms")}
}
}
}

\section{Updating Options}{

\itemize{
\item{For a single session, an option can be changed by
\verb{options(<optionToChange> = <NewValue>)}.}
\item{To change an option for a single projects across sessions in that
projects, place the options update in the \code{.Rprofile} in that project
directory.}
\item{To change an option for a user across all sessions, place the options
update in the \code{.Rprofile} file in the users home directory.}
\item{To change an option for all users in an R environment, place the
options update in the \code{.Rprofile.site} file in the R home directory.}
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://atorus-research.github.io/xportr/}
  \item \url{https://github.com/atorus-research/xportr}
  \item Report bugs at \url{https://github.com/atorus-research/xportr/issues}
}

}
\author{
\strong{Maintainer}: Eli Miller \email{Eli.Miller@AtorusResearch.com} (\href{https://orcid.org/0000-0002-2127-9456}{ORCID})

Authors:
\itemize{
  \item Ben Straub
  \item Zelos Zhu
  \item Ethan Brockmann
  \item Vedha Viyash
  \item Andre Verissimo
  \item Sophie Shapcott
  \item Celine Piraux
  \item Kangjie Zhang
  \item Adrian Chan
  \item Sadchla Mascary
}

Other contributors:
\itemize{
  \item Atorus/GSK JPT [copyright holder]
}

}
\keyword{internal}
