% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generics.R, R/update.R
\name{update}
\alias{update}
\alias{update,tskrrHomogeneous-method}
\alias{update,tskrrHeterogeneous-method}
\title{Update a tskrr object with a new lambda}
\usage{
update(object, ...)

\S4method{update}{tskrrHomogeneous}(object, lambda)

\S4method{update}{tskrrHeterogeneous}(object, lambda)
}
\arguments{
\item{object}{a \code{\link[xnet:tskrr-class]{tskrr}} object}

\item{...}{arguments passed to methods}

\item{lambda}{a numeric vector with one or two values for the
hyperparameter lambda. If two values are given, the first one is
used for the k matrix and the second for the g matrix.}
}
\value{
an updated \code{\link[xnet:tskrr-class]{tskrr}} object
fitted with the new lambdas.
}
\description{
This function allows you to refit a \code{\link{tskrr}} with a
new lambda. It can be used to do manual tuning/cross-validation.
If the object has the hat matrices stored, these are updated
as well.
}
\examples{
data(drugtarget)

mod <- tskrr(drugTargetInteraction, targetSim, drugSim)

# Update with the same lambda
mod2 <- update(mod, lambda = 1e-3)

# Use different lambda for rows and columns
mod3 <- update(mod, lambda = c(0.01,0.001))

# A model with the hat matrices stored
lambda <- c(0.001,0.01)
modkeep <- tskrr(drugTargetInteraction, targetSim, drugSim, keep = TRUE)
Hk_1 <- hat(modkeep, which = "row")
modkeep2 <- update(modkeep, lambda = lambda)
Hk_2 <- hat(modkeep2, which = "row")

# Calculate new hat matrix by hand:
decomp <- get_eigen(modkeep, which = "row")
Hk_byhand <- eigen2hat(decomp$vectors,
                       decomp$values,
                       lambda = lambda[1])
identical(Hk_2, Hk_byhand)

}
