% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_as_xml_document.R
\name{list_as_xml_document}
\alias{list_as_xml_document}
\title{Convert a list to an xml_document}
\usage{
list_as_xml_document(x, ...)
}
\arguments{
\item{x}{a list as returned by \code{\link[xml2:as_list]{xml2::as_list()}}}

\item{...}{reserved for future use}
}
\value{
an \code{xml2::xml_document}
}
\description{
\code{list_as_xml_document} is fast and efficient way to convert a list to an \code{xml2::xml_document}.
The preferred interface is to use \code{\link[=xml_fragment]{xml_fragment()}} and \code{\link[=xml_doc]{xml_doc()}} to create xml fragments.
}
\details{
\code{list_to_xml_document} is a much faster implementation of \code{xml2::as_xml_document.list()} method.
It writes the xml directly to a string buffer and then reads it back into an \code{xml2::xml_document}.

The function can be used in tandem with \code{\link[xml2:as_list]{xml2::as_list()}} to convert R data structures.
}
\examples{
data <-
  list(
    study = list(
      person = list(
        name = "John Doe",
        age = "30"
      ),
      person = list(
        name = "Jane Doe",
        age = "25"
      )
    )
  )

list_as_xml_string(data)
if (require("xml2")){
  list_as_xml_document(data)
}

#note the xml_fragment function is more powerful to create lists

data <- xml_doc("study", id = "1") /
  frag(
    person = frag(
      name = "John Doe",
      age = "30"
    ),
    person = frag(
      name = "Jane Doe",
      age = "25"
    ),
    "This is a text node"
)

list_as_xml_string(data)
}
\seealso{
Other xml2: 
\code{\link{as_xml_nodeset}()},
\code{\link{list_as_xml_string}()}
}
\concept{xml2}
