% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/x3p_extract_profile.R
\name{x3p_extract_profile}
\alias{x3p_extract_profile}
\title{Interactively select a line on the active rgl device}
\usage{
x3p_extract_profile(
  x3p,
  col = "#FF0000",
  update = TRUE,
  line_result = "equi-spaced",
  multiply = 5,
  linewidth = 1
)
}
\arguments{
\item{x3p}{x3p file}

\item{col}{character value of the selection color}

\item{update}{boolean value, whether the rgl window should be updated to show the selected circle}

\item{line_result}{enhance result by a data frame of the line: NULL for no, "raw" for data frame of original x and y (in the mask) and
projected x onto the line, "equi-spaced" (default) returns a data frame with equispaced x values after fitting a loess smooth to the raw values.
Note that variable x indicates the direction from first click (x=0) to
the second click (max x).}

\item{multiply}{integer value, factor to multiply surface values.  Only applied if update is true. Defaults to 5,}

\item{linewidth}{line width of the extracted line. Defaults to 1.}
}
\value{
x3p file with identified line in the mask. Depending on the setting of \code{line_result}
additional information on the line is attached as a data frame.
}
\description{
In the active rgl device select a line on the 3d surface by clicking on start and end-point (order matters). These points define the beginning and end  of a line segment.
The line segment is drawn on the mask of the x3p object.
The line object is returned as part of the x3p object, if \code{line_result} is set to \code{TRUE}
}
\examples{
\dontrun{
if (interactive) {
  x3p <- x3p_read(system.file("sample-land.x3p", package="x3ptools"))
  x3p \%>\% image_x3p(size=dim(x3p$surface.matrix), multiply=1, zoom=.3)
  x3p <- x3p_extract_profile(x3p, update=TRUE, col="#FFFFFF") 
  x3p$line_df \%>\% 
    ggplot(aes(x = x, y = value)) + geom_line() 
 
 x3p$line_df$y <- 1      
 sigs <- bulletxtrctr::cc_get_signature(ccdata = x3p$line_df, 
   grooves = list(groove=range(x3p$line_df$x)), span1 = 0.75, span2 = 0.03)
 sigs \%>\% 
   ggplot(aes(x = x)) + 
     geom_line(aes(y = raw_sig), colour = "grey50") +
     geom_line(aes(y = sig), size = 1) +
     theme_bw() 
}}
}
