% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/x3p_extract.R
\name{x3p_extract}
\alias{x3p_extract}
\title{Extract values from a surface matrix based on a mask}
\usage{
x3p_extract(x3p, mask_vals)
}
\arguments{
\item{x3p}{x3p object}

\item{mask_vals}{vector of mask value(s)}
}
\value{
x3p object
}
\description{
If a mask is present, a subset of the surface matrix is extracted based on specified value(s).
}
\examples{
logo <- x3p_read(system.file("csafe-logo.x3p", package="x3ptools"))
# add a mask
logo <- x3p_add_mask(logo)
mask <- t(logo$surface.matrix==median(logo$surface.matrix))
logo <- x3p_add_mask_layer(logo, mask, color = "red", annotation = "median") 
x3p_extract(logo, "#cd7f32") 
# x3p_image(logo, size=c(500,500), zoom = 1)
}
