% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectro_analysis.R
\name{spectro_analysis}
\alias{spectro_analysis}
\title{Measure acoustic parameters in batches of sound files}
\usage{
spectro_analysis(
  X,
  bp = "frange",
  wl = 512,
  wl.freq = NULL,
  threshold = 15,
  parallel = 1,
  fast = TRUE,
  path = NULL,
  pb = TRUE,
  ovlp = 50,
  wn = "hanning",
  fsmooth = 0.1,
  harmonicity = FALSE,
  nharmonics = 3,
  ...
)
}
\arguments{
\item{X}{'selection_table', 'extended_selection_table' or data frame with the following columns: 1) "sound.files": name of the sound 
files, 2) "selec": number of the selections, 3) "start": start time of selections, 4) "end": 
end time of selections.}

\item{bp}{A numeric vector of length 2 for the lower and upper limits of a 
frequency bandpass filter (in kHz) or "frange" (default) to indicate that values in bottom.freq
and top.freq columns will be used as bandpass limits.  Lower limit of
 bandpass filter is not applied to fundamental frequencies.}

\item{wl}{A numeric vector of length 1 specifying the spectrogram window length. Default is 512. See 'wl.freq' for setting windows length independently in the frequency domain.}

\item{wl.freq}{A numeric vector of length 1 specifying the window length of the spectrogram
for measurements on the frequency spectrum. Default is 512. Higher values would provide 
more accurate measurements. Note that this allows to increase measurement precision independently in the time and frequency domain. If \code{NULL} (default) then the 'wl' value is used.}

\item{threshold}{amplitude threshold (\%) for fundamental frequency and 
dominant frequency detection. Default is 15.}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{fast}{Logical. If \code{TRUE} (default) then the peakf acoustic parameter (see below) is not computed, which 
substantially increases performance (~9 times faster). This argument will be removed in future version.}

\item{path}{Character string containing the directory path where the sound files are located. 
If \code{NULL} (default) then the current working directory is used.}

\item{pb}{Logical argument to control progress bar and messages. Default is \code{TRUE}.}

\item{ovlp}{Numeric vector of length 1 specifying \% of overlap between two 
consecutive windows, used for fundamental frequency (using \code{\link[seewave]{fund}} or \code{\link[tuneR]{FF}}) and dominant frequency (using \code{\link[seewave]{dfreq}}). 
Default is 50.}

\item{wn}{Character vector of length 1 specifying window name. Default is hanning'. 
See function \code{\link[seewave]{ftwindow}} for more options.}

\item{fsmooth}{A numeric vector of length 1 to smooth the frequency spectrum with a mean
sliding window (in kHz) used for mean peak frequency detection. This help to average 
amplitude "hills" to minimize the effect of amplitude modulation. Default is 0.1.}

\item{harmonicity}{Logical. If \code{TRUE} harmonicity related parameters (fundamental frequency parameters [meanfun, minfun, maxfun], hn_freq, 
hn_width, harmonics and HNR) are measured. Note that measuring these parameters 
considerably increases computing time.}

\item{nharmonics}{Numeric vector of length 1 setting the number of harmonics to analyze.}

\item{...}{Additional parameters to be passed to \code{\link[soundgen]{analyze}}, which measures parameters related to harmonicity.}
}
\value{
Data frame with 'sound.files' and 'selec' as in the input data frame, plus the following acoustic parameters: 
\itemize{
   \item \code{duration}: length of signal (in s)
   \item \code{meanfreq}: mean frequency (in kHz). Calculated as the weighted average of the frequency spectrum (i.e. weighted by the amplitude within the supplied band pass).  
   \item \code{sd}: standard deviation of frequency (in kHz). Calculated as the weighted standard deviation of the frequency spectrum (i.e. weighted by the amplitude within the supplied band pass).  
   \item \code{freq.median}: median frequency. The frequency at which the frequency spectrum is divided in two frequency
   intervals of equal energy (in kHz) 
   \item \code{freq.Q25}: first quartile frequency. The frequency at which the frequency spectrum is divided in two 
   frequency intervals of 25\% and 75\% energy respectively (in kHz) 
   \item \code{freq.Q75}: third quartile frequency. The frequency at which the frequency spectrum is divided in two
   frequency intervals of 75\% and 25\% energy respectively (in kHz) 
   \item \code{freq.IQR}: interquartile frequency range. Frequency range between 'freq.Q25' and 'freq.Q75' 
   (in kHz) 
   \item \code{time.median}: median time. The time at which the time envelope is divided in two time
   intervals of equal energy (in s) 
   \item \code{time.Q25}: first quartile time. The time at which the time envelope is divided in two
time intervals of 25\% and 75\% energy respectively (in s). See \code{\link[seewave]{acoustat}}
   \item \code{time.Q75}: third quartile time. The time at which the time envelope is divided in two
   time intervals of 75\% and 25\% energy respectively (in s). See \code{\link[seewave]{acoustat}}
   \item \code{time.IQR}: interquartile time range. Time range between 'time.Q25' and 'time.Q75' 
   (in s). See \code{\link[seewave]{acoustat}}
   \item \code{peakt}: peak time. Time (in s) at which the maximum amplitude is found in the amplitude vector. 
   \item \code{skew}: skewness. Asymmetry of the frequency spectrum (see note in \code{\link[seewave]{specprop}} description) 
   \item \code{kurt}: kurtosis. Peakedness of the frequency spectrum (see note in \code{\link[seewave]{specprop}} description)
   \item \code{sp.ent}: spectral entropy. Energy distribution of the frequency spectrum. Pure tone ~ 0; 
   noisy ~ 1. See \code{\link[seewave]{sh}}
   \item \code{time.ent}: time entropy. Energy distribution on the time envelope. ~0 means amplitude concentrated in a specific time point, 1 means amplitude equally distributed across time. See \code{\link[seewave]{th}}
   \item \code{entropy}: spectrographic entropy. Product of time and spectral entropy \code{sp.ent * time.ent}. 
   See \code{\link[seewave]{H}}
   \item \code{sfm}: spectral flatness. Similar to sp.ent (Pure tone ~ 0; 
   noisy ~ 1). See \code{\link[seewave]{sfm}}
   \item \code{meandom}: average of dominant frequency measured across the spectrogram 
   \item \code{mindom}: minimum of dominant frequency measured across the spectrogram
   \item \code{maxdom}: maximum of dominant frequency measured across the spectrogram 
   \item \code{dfrange}: range of dominant frequency measured across the spectrogram 
   \item \code{modindx}: modulation index. Calculated as the cumulative absolute
     difference between adjacent measurements of dominant frequencies divided
     by the dominant frequency range (measured on the spectrogram). 1 means the signal is not modulated. 
   \item \code{startdom}:  dominant frequency measurement at the start of the signal (measured on the spectrogram).
   \item \code{enddom}: dominant frequency measurement at the end of the signal(measured on the spectrogram).
   \item \code{dfslope}: slope of the change in dominant frequency (measured on the spectrogram) through time ((enddom-startdom)/duration). Units are kHz/s.  
   \item \code{peakf}: peak frequency. Frequency with the highest energy. This 
   parameter can take a considerable amount of time to measure. It's only 
   generated if \code{fast = FALSE}. It provides a more accurate measure of peak
   frequency than 'meanpeakf' but can be more easily affected by background noise. Measured on the frequency spectrum.
   \item \code{meanpeakf}: mean peak frequency. Frequency with highest energy from the 
   mean frequency spectrum (see \code{\link[seewave]{meanspec}}). Typically more consistent than peakf in the presence of noise.
   \item \code{meanfun}: average of fundamental frequency measured across the acoustic signal. Only measured if \code{harmonicity = TRUE}.
   \item \code{minfun}: minimum fundamental  frequency measured across the acoustic signal. Only measured if \code{harmonicity = TRUE}.
   \item \code{maxfun}: maximum fundamental frequency measured across the acoustic signal. Only measured if \code{harmonicity = TRUE}.
   \item \code{hn_freq}: mean frequency of the 'n' upper harmonics (kHz) (see \code{\link[soundgen]{analyze}}). 
   Number of harmonics is defined with the argument 'nharmonics'. Only measured if \code{harmonicity = TRUE}.
   \item \code{hn_width}: mean bandwidth of the 'n' upper harmonics (kHz) (see \code{\link[soundgen]{analyze}}). Number of harmonics is defined with the argument 'nharmonics'. Only measured if \code{harmonicity = TRUE}.  
   \item \code{harmonics}: the amount of energy in upper harmonics, namely the 
   ratio of total spectral power above 1.25 x F0 to the total spectral power 
   below 1.25 x F0 (dB) (see \code{\link[soundgen]{analyze}}). Number of 
   harmonics is defined with the argument 'nharmonics'. Only measured if \code{harmonicity = TRUE}.
   \item \code{HNR}: harmonics-to-noise ratio (dB). A measure of the harmonic content generated by \code{\link[soundgen]{getPitchAutocor}}. Only measured if \code{harmonicity = TRUE}.
}
}
\description{
\code{spectro_analysis} measures acoustic parameters on acoustic signals for which the start and end times 
are provided.
}
\details{
The function measures 30 acoustic parameters (if \code{fast = TRUE}) on 
 each selection in the data frame. Most parameters are produced internally by 
 \code{\link[seewave]{specprop}}, \code{\link[seewave]{fpeaks}}, \code{\link[seewave]{fund}},
 and \code{\link[seewave]{dfreq}} from the package seewave and \code{\link[soundgen]{analyze}} 
 from the package soundgen. NAs are produced for fundamental and dominant 
 frequency measures when there are no amplitude values above the threshold. 
 Additional parameters can be provided to the internal function \code{\link[soundgen]{analyze}}, which measures parameters related to harmonicity.
}
\examples{
{
data(list = c("Phae.long1", "Phae.long2", "Phae.long3", "lbh_selec_table"))
writeWave(Phae.long1, file.path(tempdir(), "Phae.long1.wav"))
writeWave(Phae.long2, file.path(tempdir(), "Phae.long2.wav"))
writeWave(Phae.long3, file.path(tempdir(), "Phae.long3.wav"))

# measure acoustic parameters
sp_param <- spectro_analysis(X = lbh_selec_table[1:8,], pb = FALSE, path = tempdir())

# measuring peakf
sp_param <- spectro_analysis(X = lbh_selec_table[1:8,], pb = FALSE, fast = FALSE, path = tempdir())

\donttest{
# measuring harmonic-related parameters using progress bar
sp_param <- spectro_analysis(X = lbh_selec_table[1:8,], harmonicity = TRUE, 
path = tempdir(), ovlp = 70)
}
}
}
\references{
Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals. Methods in Ecology and Evolution, 8(2), 184-191.
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr}) and Grace Smith Vidaurre
}
