% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{theme_vlkr}
\alias{theme_vlkr}
\title{Define a default theme for volker plots}
\usage{
theme_vlkr(
  base_size = 11,
  base_color = "black",
  base_fill = VLKR_FILLDISCRETE,
  base_gradient = VLKR_FILLGRADIENT
)
}
\arguments{
\item{base_size}{Base font size.}

\item{base_color}{Base font color.}

\item{base_fill}{A list of fill color sets or at least one fill color set. Example:
\code{list(c("red"), c("red", "blue", "green"))}.
Each set can contain different numbers of colors.
Depending on the number of colors needed,
the set with at least the number of required colors is used.
The first color is always used for simple bar charts.}

\item{base_gradient}{A color vector used for creating gradient fill colors, e.g. in stacked bar plots.}
}
\value{
A theme function.
}
\description{
Set ggplot colors, sizes and layout parameters.
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
library(volker)
library(ggplot2)
data <- volker::chatgpt

theme_set(theme_vlkr(base_size=15, base_fill = list("red")))
plot_counts(data, sd_gender)
}
