% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/embed_media.R
\name{embed_video}
\alias{embed_video}
\title{Embed video in R Markdown documents}
\usage{
embed_video(
  src,
  type = c("mp4", "webm", "ogg"),
  width = "320",
  height = "240",
  attribute = c("controls", "autoplay", "loop", "muted", "preload", "none"),
  thumbnail = NULL,
  id = "",
  placeholder = ""
)
}
\arguments{
\item{src}{A path or URL to the media file.}

\item{type}{The type of media file specified in `src`.}

\item{width}{The width of the video, in pixels.}

\item{height}{The height of the video, in pixels.}

\item{attribute}{A character vector specifying which attributes to use.
"none" can be used if no attributes are desired.}

\item{thumbnail}{A path to an image.}

\item{id}{A character string specifying a unique ID for the element.
Can be used by CSS or JavaScript to perform certain tasks for
the element with the specific ID.}

\item{placeholder}{The placeholder text to use when the output format is
not HTML.}
}
\value{
If `knitr::is_html_output()` is `TRUE`, returns HTML `<video>` code.
  If `knitr::is_html_output()` is `FALSE`, returns placeholder text.
}
\description{
`embed_video()` provides a standard way to embed video in R Markdown
documents when the output format is HTML, and to print placeholder text
when the output format is not HTML.
}
\details{
`embed_video()` is a wrapper for the HTML5 `<video>` element that prints
HTML `<video>` code in HTML documents built by R Markdown and placeholder
text in non-HTML documents built by R Markdown. This function may be useful
for conditional output that depends on the output format. For example, you
may embed video in an R Markdown document when the output format is HTML,
and print placeholder text when the output format is LaTeX.

The function determines output format using [knitr::is_html_output()]. By
default, these formats are considered as HTML formats: `c('markdown',
'epub', 'html', 'html5', 'revealjs', 's5', 'slideous', 'slidy')`.
}
\note{
This function is supposed to be used in R code chunks or inline R code
  expressions. You are recommended to use forward slashes (/) as path
  separators instead of backslashes in the file paths.
}
\examples{
# By default, embed_video() embeds a video element with playback controls
embed_video(mp4)

# To change the attributes of the video element, use `attribute`
embed_video(mp4, attribute = c("controls", "loop"))

# To add a thumbnail to the video element, use `thumbnail`
embed_video(mp4, thumbnail = png)

# To add placeholder text for non-HTML documents, use `placeholder`
embed_video(mp4, placeholder = "This is placeholder text.")

\dontrun{
# embed_video() is intended to be used in R Markdown code chunks or inline
# expressions. The following creates and knits an R Markdown document to
# HTML and PDF in your current working directory for you to inspect:
library(rmarkdown)
writeLines(c("# Hello embedr!",
"```{r embed-video, echo=TRUE}",
"embed_video(mp4, thumbnail = png, placeholder = 'This is placeholder text.')",
"```"), "test.Rmd")
render("test.Rmd", output_format = c('html_document', 'pdf_document'))

# Delete test files created by example code
unlink(c("test.Rmd", "test.html", "test.pdf"))
}
}
