% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PdfFileComparator.R
\name{PdfFileComparator}
\alias{PdfFileComparator}
\title{PdfFileComparator.R}
\description{
PdfFileComparator.R

PdfFileComparator.R
}
\details{
Specialiced comparator for PDF file comparison.
This comparator contains the custom handling for handling only PDF content
part for the comparison.
}
\examples{

# The normal way for creating a comparator would be to call the generic
# factory method verifyr2::create_comparator that will automatically create
# the correct comparator instance based on the file types.

file1 <- 'my_file1.pdf'
file2 <- 'my_file2.pdf'
comparator <- verifyr2::create_comparator(file1, file2)

# If needed, an explicit comparator can be created as well.

file1 <- 'my_file1.pdf'
file2 <- 'my_file2.pdf'
comparator <- PdfFileComparator$new(file1, file2)

}
\section{Super classes}{
\code{\link[verifyr2:FileComparator]{verifyr2::FileComparator}} -> \code{\link[verifyr2:BinaryFileComparator]{verifyr2::BinaryFileComparator}} -> \code{\link[verifyr2:TxtFileComparator]{verifyr2::TxtFileComparator}} -> \code{PdfFileComparator}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PdfFileComparator-vrf_contents}{\code{PdfFileComparator$vrf_contents()}}
\item \href{#method-PdfFileComparator-vrf_details_supported}{\code{PdfFileComparator$vrf_details_supported()}}
\item \href{#method-PdfFileComparator-clone}{\code{PdfFileComparator$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="FileComparator" data-id="initialize"><a href='../../verifyr2/html/FileComparator.html#method-FileComparator-initialize'><code>verifyr2::FileComparator$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="FileComparator" data-id="vrf_add_debug"><a href='../../verifyr2/html/FileComparator.html#method-FileComparator-vrf_add_debug'><code>verifyr2::FileComparator$vrf_add_debug()</code></a></span></li>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="FileComparator" data-id="vrf_add_debug_files"><a href='../../verifyr2/html/FileComparator.html#method-FileComparator-vrf_add_debug_files'><code>verifyr2::FileComparator$vrf_add_debug_files()</code></a></span></li>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="FileComparator" data-id="vrf_close_debug"><a href='../../verifyr2/html/FileComparator.html#method-FileComparator-vrf_close_debug'><code>verifyr2::FileComparator$vrf_close_debug()</code></a></span></li>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="FileComparator" data-id="vrf_details"><a href='../../verifyr2/html/FileComparator.html#method-FileComparator-vrf_details'><code>verifyr2::FileComparator$vrf_details()</code></a></span></li>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="FileComparator" data-id="vrf_open_debug"><a href='../../verifyr2/html/FileComparator.html#method-FileComparator-vrf_open_debug'><code>verifyr2::FileComparator$vrf_open_debug()</code></a></span></li>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="FileComparator" data-id="vrf_option_value"><a href='../../verifyr2/html/FileComparator.html#method-FileComparator-vrf_option_value'><code>verifyr2::FileComparator$vrf_option_value()</code></a></span></li>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="FileComparator" data-id="vrf_summary"><a href='../../verifyr2/html/FileComparator.html#method-FileComparator-vrf_summary'><code>verifyr2::FileComparator$vrf_summary()</code></a></span></li>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="TxtFileComparator" data-id="vrf_contents_inner"><a href='../../verifyr2/html/TxtFileComparator.html#method-TxtFileComparator-vrf_contents_inner'><code>verifyr2::TxtFileComparator$vrf_contents_inner()</code></a></span></li>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="TxtFileComparator" data-id="vrf_details_inner"><a href='../../verifyr2/html/TxtFileComparator.html#method-TxtFileComparator-vrf_details_inner'><code>verifyr2::TxtFileComparator$vrf_details_inner()</code></a></span></li>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="TxtFileComparator" data-id="vrf_summary_inner"><a href='../../verifyr2/html/TxtFileComparator.html#method-TxtFileComparator-vrf_summary_inner'><code>verifyr2::TxtFileComparator$vrf_summary_inner()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PdfFileComparator-vrf_contents"></a>}}
\if{latex}{\out{\hypertarget{method-PdfFileComparator-vrf_contents}{}}}
\subsection{Method \code{vrf_contents()}}{
Method for getting the single file contents for the comparison. The
method returns the file contents in two separate vectors inside a list.
The first vector is the file contents and the second one is the file
contents with the rows matching the omit string excluded. This method
can be overwritten by more specialized comparator classes. This method
is intended to be called only by the comparator classes in the processing
and shouldn't be called directly by the user.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PdfFileComparator$vrf_contents(file, config, omit)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{file for which to get the contents}

\item{\code{config}}{configuration values}

\item{\code{omit}}{string pattern to omit from the comparison}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PdfFileComparator-vrf_details_supported"></a>}}
\if{latex}{\out{\hypertarget{method-PdfFileComparator-vrf_details_supported}{}}}
\subsection{Method \code{vrf_details_supported()}}{
Inherited method for indicating whether detailed comparison is available
with the current comparator. Returns an empty string if the comparator is
is supported, otherwise a string that will be concatenated with the
summary string.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PdfFileComparator$vrf_details_supported(config)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{config}}{configuration values}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PdfFileComparator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PdfFileComparator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PdfFileComparator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
