% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position-jitter-ellipse.R
\name{position_jitter_ellipse}
\alias{position_jitter_ellipse}
\title{Jitter points on an ellipse to avoid over-plotting}
\usage{
position_jitter_ellipse(width = NULL, height = NULL, seed = NA)
}
\arguments{
\item{width, height}{The dimensions of the elliptical field,
from which over-plotted points are sampled.}

\item{seed}{A random seed for reproducibility.}
}
\value{
A \code{ggproto} object of class \code{PositionJitterEllipse}.
}
\description{
This function adds elliptical random noise to perfectly over-plotted points,
offering a pleasing way to visualize many points that represent the same position.
In contrast to the position_jitter() function which samples from a rectangular field,
the position_jitter_ellipse() function samples from an elliptical field.
This function takes algorithmic inspiration from https://stackoverflow.com/questions/5529148/algorithm-calculate-pseudo-random-point-inside-an-ellipse
and https://stats.stackexchange.com/questions/120527/simulate-a-uniform-distribution-on-a-disc.
}
\examples{
  library(ggplot2)

  dat <- data.frame(x = rep(1, 500), y = rep(1, 500))

  # Jitter on an ellipse.
  ggplot(dat, aes(x, y)) +
    geom_point(position = position_jitter_ellipse(width = 0.5, height = 0.5)) +
    coord_cartesian(xlim = c(0, 2), ylim = c(0, 2))

  # Jitter on a rectangle, for comparison.
  ggplot(dat, aes(x, y)) +
    geom_point(position = position_jitter(width = 0.5, height = 0.5)) +
    coord_cartesian(xlim = c(0, 2), ylim = c(0, 2))

}
\seealso{
Other Functions: 
\code{\link{position_circlepack}()},
\code{\link{position_circlepackdodge}()},
\code{\link{position_jitterdodge_ellipse}()},
\code{\link{position_sunflower}()},
\code{\link{position_sunflowerdodge}()},
\code{\link{sunflower}()}
}
\concept{Functions}
