% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/af.R
\name{af}
\alias{af}
\alias{arp}
\alias{parp}
\title{Attributable fractions}
\usage{
arp(.data, exposure, outcome, alpha = 0.05, percent = FALSE, ...)

parp(
  .data,
  exposure,
  outcome,
  alpha = 0.05,
  percent = FALSE,
  prevalence = NULL,
  ...
)
}
\arguments{
\item{.data}{Either a data frame with observation-level exposure and outcome data or a \link[twoxtwo]{twoxtwo} object}

\item{exposure}{Name of exposure variable; ignored if input to \code{.data} is a \code{twoxtwo} object}

\item{outcome}{Name of outcome variable; ignored if input to \code{.data} is a \code{twoxtwo} object}

\item{alpha}{Significance level to be used for constructing confidence interval; default is \code{0.05}}

\item{percent}{Logical as to whether or not the measure should be returned as a percentage; default is \code{FALSE}}

\item{...}{Additional arguments passed to \link[twoxtwo]{twoxtwo} function; ignored if input to \code{.data} is a \code{twoxtwo} object}

\item{prevalence}{Prevalence of exposure in the population; must be numeric between \code{0} and \code{1}; only used in \code{parp()}; default is \code{NULL} and will be ignored}
}
\value{
A \code{tibble} with the following columns:
\itemize{
\item \strong{measure}: Name of the measure calculated
\item \strong{estimate}: Point estimate for the effect measure
\item \strong{ci_lower}: The lower bound of the confidence interval for the estimate
\item \strong{ci_upper}: The upper bound of the confidence interval for the estimate
\item \strong{exposure}: Name of the exposure variable followed by +/- levels (e.g. smoking::yes/no)
\item \strong{outcome}: Name of the outcome variable followed by +/- levels (e.g. heart_disease::yes/no)
}
}
\description{
In addition to \link[twoxtwo]{measures} of effect such as odds ratio, risk ratio, and risk difference, the \link[twoxtwo]{twoxtwo} framework allows for calculation of attributable fractions: attributable risk proportion in the exposed (ARP) and the population attributable risk proportion (PARP).

Estimates of the attributable fractions can be calculated with the \code{arp()} and \code{parp()} functions respectively.  Each function takes an input dataset and arguments for outcome and exposure as bare, unquoted variable names. If the input has the  \link[twoxtwo]{twoxtwo} class then the effect measures will be calculated using exposure and outcome information from that object. The functions all return a tidy \code{tibble} with the name of the measure, the point estimate, and lower/upper bounds of a confidence interval (CI) based on the SE.

Formulas used in point estimate and SE calculations are available in 'Details'.
}
\details{
The formulas below denote cell values as A,B,C,D. For more on \code{twoxtwo} notation see the \link[twoxtwo]{twoxtwo} documentation.

Note that formulas for standard errors are not provided below but are based on forumlas described in Hildebrandt et al (2006).
\subsection{Attributable Risk Proportion in the Exposed (ARP)}{

\deqn{ARP = 1 - (1/((A/(A+B)) / (C/(C+D))))}
}

\subsection{Population Attributable Risk Proportion (PARP)}{

\deqn{PARP = (((A+C)/(A+B+C+D))-(C/(C+D)))) / ((A+C)/(A+B+C+D))}

If "prevalence" argument is not \code{NULL} then the formula uses the value specified for prevalence of exposure (p):

\deqn{PARP = p * (((A/(A+B)) / (C/(C+D))) - 1) / (p * (((A/(A+B)) / (C/(C+D))) - 1) + 1)}
}
}
\references{
Hildebrandt, M., Bender, R., Gehrmann, U., & Blettner, M. (2006). Calculating confidence intervals for impact numbers. BMC medical research methodology, 6, 32. https://doi.org/10.1186/1471-2288-6-32

Szklo, M., & Nieto, F. J. (2007). Epidemiology: Beyond the basics. Sudbury, Massachussets: Jones and Bartlett.

Zapata-Diomedi, B., Barendregt, J. J., & Veerman, J. L. (2018). Population attributable fraction: names, types and issues with incorrect interpretation of relative risks. British journal of sports medicine, 52(4), 212–213. https://doi.org/10.1136/bjsports-2015-095531
}
