% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_integtune.R
\name{ts_integtune}
\alias{ts_integtune}
\title{Time Series Integrated Tune}
\usage{
ts_integtune(
  input_size,
  base_model,
  folds = 10,
  ranges = NULL,
  preprocess = list(ts_norm_gminmax()),
  augment = list(ts_aug_none())
)
}
\arguments{
\item{input_size}{Integer vector. Candidate input window sizes.}

\item{base_model}{Base model object for tuning.}

\item{folds}{Integer. Number of cross-validation folds.}

\item{ranges}{Named list of hyperparameter ranges to explore.}

\item{preprocess}{List of preprocessing objects to compare.}

\item{augment}{List of augmentation objects to apply during training.}
}
\value{
A \code{ts_integtune} object.
}
\description{
Integrated tuning over input sizes, preprocessing, augmentation,
and model hyperparameters for time series.
}
\examples{
# Integrated search over input size, preprocessing and model hyperparameters
library(daltoolbox)
data(tsd)

# Build windows and split into train/test, then project to (X, y)
ts <- ts_data(tsd$y, 10)
samp <- ts_sample(ts, test_size = 5)
io_train <- ts_projection(samp$train)
io_test <- ts_projection(samp$test)

# Configure integrated tuning: ranges for input_size, ELM (nhid, actfun), and preprocessors
tune <- ts_integtune(
  input_size = 3:5,
  base_model = ts_elm(),
  ranges = list(nhid = 1:5, actfun = c('purelin')),
  preprocess = list(ts_norm_gminmax())
)

# Run search; augmentation (if provided) is applied during training internally
model <- fit(tune, x = io_train$input, y = io_train$output)

# Forecast and evaluate on the held-out window
prediction <- predict(model, x = io_test$input[1,], steps_ahead = 5)
prediction <- as.vector(prediction)
output <- as.vector(io_test$output)

ev_test <- evaluate(model, output, prediction)
ev_test
}
\references{
Salles, R., Pacitti, E., Bezerra, E., Marques, C., Pacheco, C., Oliveira,
C., Porto, F., Ogasawara, E. (2023). TSPredIT: Integrated Tuning of Data
Preprocessing and Time Series Prediction Models. Lecture Notes in Computer
Science.
}
