% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rmest}
\alias{rmest}
\title{Estimate of Restricted Mean Survival Time}
\usage{
rmest(
  data,
  stratum = "",
  time = "time",
  event = "event",
  milestone = 0,
  conflev = 0.95,
  biascorrection = FALSE
)
}
\arguments{
\item{data}{The input data frame that contains the following variables:
\itemize{
\item \code{stratum}: The stratum.
\item \code{time}: The possibly right-censored survival time.
\item \code{event}: The event indicator.
}}

\item{stratum}{The name of the stratum variable in the input data.}

\item{time}{The name of the time variable in the input data.}

\item{event}{The name of the event variable in the input data.}

\item{milestone}{The milestone time at which to calculate the
restricted mean survival time.}

\item{conflev}{The level of the two-sided confidence interval for
the survival probabilities. Defaults to 0.95.}

\item{biascorrection}{Whether to apply bias correction for the
variance estimate. Defaults to no bias correction.}
}
\value{
A data frame with the following variables:
\itemize{
\item \code{stratum}: The stratum variable.
\item \code{size}: The number of subjects in the stratum.
\item \code{milestone}: The milestone time relative to randomization.
\item \code{rmst}: The estimate of restricted mean survival time.
\item \code{stderr}: The standard error of the estimated rmst.
\item \code{lower}: The lower bound of confidence interval if requested.
\item \code{upper}: The upper bound of confidence interval if requested.
\item \code{conflev}: The level of confidence interval if requested.
\item \code{biascorrection}: Whether to apply bias correction for the
variance estimate.
}
}
\description{
Obtains the estimate of restricted means survival time
for each stratum.
}
\examples{

rmest(data = aml, stratum = "x",
      time = "time", event = "status", milestone = 24)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
