% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/two_source_priors.R
\name{two_source_priors}
\alias{two_source_priors}
\title{Bayesian priors - Two Source Trophic Position}
\usage{
two_source_priors(bp = FALSE)
}
\arguments{
\item{bp}{logical value that controls whether informed priors are
supplied to the model for both \eqn{\delta^{15}}N and
\eqn{\delta^{15}}C baselines. Default is \code{FALSE} meaning the model will
use uninformed priors, however, the supplied \code{data.frame} needs values
for both \eqn{\delta^{15}}N and \eqn{\delta^{15}}C baseline
(\code{c1}, \code{c2}, \code{n1}, and \code{n2}).}
}
\value{
returns priors for two source model to be used in a \code{brms()} call.
}
\description{
Create priors for two source trophic position model derived from
\href{https://esajournals.onlinelibrary.wiley.com/doi/full/10.1890/0012-9658\%282002\%29083\%5B0703\%3AUSITET\%5D2.0.CO\%3B2}{Post 2002}.
}
\examples{
two_source_priors()

}
\seealso{
\code{\link[=two_source_model]{two_source_model()}} and \code{\link[brms:brms-package]{brms::brms()}}
}
