% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tricolore.R
\docType{data}
\name{euro_example}
\alias{euro_example}
\title{NUTS-2 Level Geodata and Compositional Data for Europe}
\format{
A data frame with 312 rows and 9 variables:
  \describe{
    \item{id}{NUTS-2 code.}
    \item{name}{Name of NUTS-2 region.}
    \item{ed_0to2}{Share of population with highest attained education "lower secondary or less".}
    \item{ed_3to4}{Share of population with highest attained education "upper secondary".}
    \item{ed_5to8}{Share of population with highest attained education "tertiary".}
    \item{lf_pri}{Share of labor-force in primary sector.}
    \item{lf_sec}{Share of labor-force in secondary sector.}
    \item{lf_ter}{Share of labor-force in tertiary sector.}
    \item{geometry}{Polygon outlines for regions in sf package format.}
  }
}
\source{
Derived from Eurostats European Geodata.
  (c) EuroGeographics for the administrative boundaries.
  \url{https://gisco-services.ec.europa.eu/distribution/v2/nuts/nuts-2016-files.html}

  Education data derived from Eurostats table "edat_lfse_04".

  Labor-force data derived from Eurostats table "lfst_r_lfe2en2".
}
\usage{
euro_example
}
\description{
A simple-features dataframe containing the NUTS-2 level polygons of European
regions along with regional compositional data on education and labor-force.
}
\details{
Variables starting with "ed" refer to the relative share of population ages
  25 to 64 by educational attainment in the European NUTS-2 regions 2016.

  Variables starting with "lf" refer to the relative share of workers by
  labor-force sector in the European NUTS-2 regions 2016. The original NACE
  (rev. 2) codes have been recoded into the three sectors "primary" (A),
  "secondary" (B-E & F) and "tertiary" (all other NACE codes).
}
\keyword{datasets}
