% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{node_show_s_expression}
\alias{node_show_s_expression}
\title{Pretty print a \code{node}'s s-expression}
\usage{
node_show_s_expression(
  x,
  ...,
  max_lines = NULL,
  show_anonymous = TRUE,
  show_locations = TRUE,
  show_parentheses = TRUE,
  dangling_parenthesis = TRUE,
  color_parentheses = TRUE,
  color_locations = TRUE
)
}
\arguments{
\item{x}{\verb{[tree_sitter_node]}

A node.}

\item{...}{These dots are for future extensions and must be empty.}

\item{max_lines}{\verb{[double(1) / NULL]}

An optional maximum number of lines to print. If the maximum is hit, then
\verb{<truncated>} will be printed at the end.}

\item{show_anonymous}{\verb{[bool]}

Should anonymous nodes be shown? If \code{FALSE}, only named nodes are shown.}

\item{show_locations}{\verb{[bool]}

Should node locations be shown?}

\item{show_parentheses}{\verb{[bool]}

Should parentheses around each node be shown?}

\item{dangling_parenthesis}{\verb{[bool]}

Should the \verb{)} parenthesis "dangle" on its own line? If \code{FALSE}, it is
appended to the line containing the last child. This can be useful for
conserving space.}

\item{color_parentheses}{\verb{[bool]}

Should parentheses be colored? Printing large s-expressions is faster if
this is set to \code{FALSE}.}

\item{color_locations}{\verb{[bool]}

Should locations be colored? Printing large s-expressions is faster if
this is set to \code{FALSE}.}
}
\value{
\code{x} invisibly.
}
\description{
\code{node_show_s_expression()} prints a nicely formatted s-expression to the
console. It powers the print methods of nodes and trees.
}
\examples{
\dontshow{if (rlang::is_installed("treesitter.r")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
language <- treesitter.r::language()
parser <- parser(language)

text <- "fn <- function(a, b = 2) { a + b + 2 }"
tree <- parser_parse(parser, text)
node <- tree_root_node(tree)

node_show_s_expression(node)

node_show_s_expression(node, max_lines = 5)

# This is more like a typical abstract syntax tree
node_show_s_expression(
  node,
  show_anonymous = FALSE,
  show_locations = FALSE,
  dangling_parenthesis = FALSE
)
\dontshow{\}) # examplesIf}
}
