% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree-cursor.R
\name{TreeCursor}
\alias{TreeCursor}
\title{Tree cursors}
\value{
R6 object representing the tree cursor.
}
\description{
\code{TreeCursor} is an R6 class that allows you to walk a tree in a more
efficient way than calling \verb{node_*()} functions like \code{\link[=node_child]{node_child()}}
repeatedly.

You can also more elegantly create a cursor with \code{\link[=node_walk]{node_walk()}} and
\code{\link[=tree_walk]{tree_walk()}}.
}
\examples{
\dontshow{if (rlang::is_installed("treesitter.r")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
language <- treesitter.r::language()
parser <- parser(language)

text <- "fn <- function(a, b) { a + b }"

tree <- parser_parse(parser, text)
node <- tree_root_node(tree)

cursor <- TreeCursor$new(node)

cursor$node()
cursor$goto_first_child()
cursor$goto_first_child()
cursor$node()
cursor$goto_next_sibling()
cursor$node()
\dontshow{\}) # examplesIf}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-tree_sitter_tree_cursor-new}{\code{TreeCursor$new()}}
\item \href{#method-tree_sitter_tree_cursor-reset}{\code{TreeCursor$reset()}}
\item \href{#method-tree_sitter_tree_cursor-node}{\code{TreeCursor$node()}}
\item \href{#method-tree_sitter_tree_cursor-field_name}{\code{TreeCursor$field_name()}}
\item \href{#method-tree_sitter_tree_cursor-field_id}{\code{TreeCursor$field_id()}}
\item \href{#method-tree_sitter_tree_cursor-descendant_index}{\code{TreeCursor$descendant_index()}}
\item \href{#method-tree_sitter_tree_cursor-goto_parent}{\code{TreeCursor$goto_parent()}}
\item \href{#method-tree_sitter_tree_cursor-goto_next_sibling}{\code{TreeCursor$goto_next_sibling()}}
\item \href{#method-tree_sitter_tree_cursor-goto_previous_sibling}{\code{TreeCursor$goto_previous_sibling()}}
\item \href{#method-tree_sitter_tree_cursor-goto_first_child}{\code{TreeCursor$goto_first_child()}}
\item \href{#method-tree_sitter_tree_cursor-goto_last_child}{\code{TreeCursor$goto_last_child()}}
\item \href{#method-tree_sitter_tree_cursor-depth}{\code{TreeCursor$depth()}}
\item \href{#method-tree_sitter_tree_cursor-goto_first_child_for_byte}{\code{TreeCursor$goto_first_child_for_byte()}}
\item \href{#method-tree_sitter_tree_cursor-goto_first_child_for_point}{\code{TreeCursor$goto_first_child_for_point()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-tree_sitter_tree_cursor-new"></a>}}
\if{latex}{\out{\hypertarget{method-tree_sitter_tree_cursor-new}{}}}
\subsection{Method \code{new()}}{
Create a new tree cursor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreeCursor$new(node)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{node}}{\verb{[tree_sitter_node]}

The node to start walking from.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-tree_sitter_tree_cursor-reset"></a>}}
\if{latex}{\out{\hypertarget{method-tree_sitter_tree_cursor-reset}{}}}
\subsection{Method \code{reset()}}{
Reset the tree cursor to a new root node.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreeCursor$reset(node)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{node}}{\verb{[tree_sitter_node]}

The node to start walking from.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-tree_sitter_tree_cursor-node"></a>}}
\if{latex}{\out{\hypertarget{method-tree_sitter_tree_cursor-node}{}}}
\subsection{Method \code{node()}}{
Get the current node that the cursor points to.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreeCursor$node()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-tree_sitter_tree_cursor-field_name"></a>}}
\if{latex}{\out{\hypertarget{method-tree_sitter_tree_cursor-field_name}{}}}
\subsection{Method \code{field_name()}}{
Get the field name of the current node.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreeCursor$field_name()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-tree_sitter_tree_cursor-field_id"></a>}}
\if{latex}{\out{\hypertarget{method-tree_sitter_tree_cursor-field_id}{}}}
\subsection{Method \code{field_id()}}{
Get the field id of the current node.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreeCursor$field_id()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-tree_sitter_tree_cursor-descendant_index"></a>}}
\if{latex}{\out{\hypertarget{method-tree_sitter_tree_cursor-descendant_index}{}}}
\subsection{Method \code{descendant_index()}}{
Get the descendent index of the current node.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreeCursor$descendant_index()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-tree_sitter_tree_cursor-goto_parent"></a>}}
\if{latex}{\out{\hypertarget{method-tree_sitter_tree_cursor-goto_parent}{}}}
\subsection{Method \code{goto_parent()}}{
Go to the current node's parent.

Returns \code{TRUE} if a parent was found, and \code{FALSE} if not.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreeCursor$goto_parent()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-tree_sitter_tree_cursor-goto_next_sibling"></a>}}
\if{latex}{\out{\hypertarget{method-tree_sitter_tree_cursor-goto_next_sibling}{}}}
\subsection{Method \code{goto_next_sibling()}}{
Go to the current node's next sibling.

Returns \code{TRUE} if a sibling was found, and \code{FALSE} if not.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreeCursor$goto_next_sibling()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-tree_sitter_tree_cursor-goto_previous_sibling"></a>}}
\if{latex}{\out{\hypertarget{method-tree_sitter_tree_cursor-goto_previous_sibling}{}}}
\subsection{Method \code{goto_previous_sibling()}}{
Go to the current node's previous sibling.

Returns \code{TRUE} if a sibling was found, and \code{FALSE} if not.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreeCursor$goto_previous_sibling()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-tree_sitter_tree_cursor-goto_first_child"></a>}}
\if{latex}{\out{\hypertarget{method-tree_sitter_tree_cursor-goto_first_child}{}}}
\subsection{Method \code{goto_first_child()}}{
Go to the current node's first child.

Returns \code{TRUE} if a child was found, and \code{FALSE} if not.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreeCursor$goto_first_child()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-tree_sitter_tree_cursor-goto_last_child"></a>}}
\if{latex}{\out{\hypertarget{method-tree_sitter_tree_cursor-goto_last_child}{}}}
\subsection{Method \code{goto_last_child()}}{
Go to the current node's last child.

Returns \code{TRUE} if a child was found, and \code{FALSE} if not.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreeCursor$goto_last_child()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-tree_sitter_tree_cursor-depth"></a>}}
\if{latex}{\out{\hypertarget{method-tree_sitter_tree_cursor-depth}{}}}
\subsection{Method \code{depth()}}{
Get the depth of the current node.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreeCursor$depth()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-tree_sitter_tree_cursor-goto_first_child_for_byte"></a>}}
\if{latex}{\out{\hypertarget{method-tree_sitter_tree_cursor-goto_first_child_for_byte}{}}}
\subsection{Method \code{goto_first_child_for_byte()}}{
Move the cursor to the first child of its current node that extends
beyond the given byte offset.

Returns \code{TRUE} if a child was found, and \code{FALSE} if not.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreeCursor$goto_first_child_for_byte(byte)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{byte}}{\verb{[double(1)]}

The byte to move the cursor past.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-tree_sitter_tree_cursor-goto_first_child_for_point"></a>}}
\if{latex}{\out{\hypertarget{method-tree_sitter_tree_cursor-goto_first_child_for_point}{}}}
\subsection{Method \code{goto_first_child_for_point()}}{
Move the cursor to the first child of its current node that extends
beyond the given point.

Returns \code{TRUE} if a child was found, and \code{FALSE} if not.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TreeCursor$goto_first_child_for_point(point)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{point}}{\verb{[tree_sitter_point]}

The point to move the cursor past.}
}
\if{html}{\out{</div>}}
}
}
}
