% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colPlaLab.R
\name{colPlaLab}
\alias{colPlaLab}
\title{Calculation of the Colijn-Plazzotta rank for rooted binary trees}
\usage{
colPlaLab(tree)
}
\arguments{
\item{tree}{A rooted binary tree in phylo format.}
}
\value{
\code{colPlaLab} returns the Colijn-Plazotta rank of the given tree. Since the values can get quite large, the
function returns them in big.z format (package gmp).
}
\description{
This function calculates the Colijn-Plazzotta rank \eqn{CP(T)} for a
given rooted binary tree \eqn{T}.\cr\cr
For a binary tree \eqn{T}, the Colijn-Plazzotta rank \eqn{CP(T)} is
recursively defined as \eqn{CP(T)=1} if \eqn{T} consists of only
one leaf and otherwise
\deqn{CP(T)=\frac{1}{2}\cdot CP(T_1)\cdot(CP(T_1)-1)+CP(T_2)+1}{CP(T)=1/2*CP(T1)(CP(T1)-1)+CP(T2)+1}
with \eqn{CP(T_1) \geq CP(T_2)}{CP(T1)>=CP(T2)} being the ranks of the two pending
subtrees rooted at the children of the root of \eqn{T}. This rank
of \eqn{T} corresponds to its position in the
lexicographically sorted list of (\eqn{i,j}): (1),(1,1),(2,1),(2,2),(3,1),...
The Colijn-Plazzotta rank of binary trees has been shown to be an imbalance index.\cr\cr
For \eqn{n=1} the function returns \eqn{CP(T)=1} and a warning.\cr\cr
Note that problems can sometimes arise even for trees with small leaf numbers due
to the limited range of computable values (ranks can reach INF quickly). \cr\cr
For details on the Colijn-Plazzotta rank, see 
also Chapter 21 in "Tree balance indices: a comprehensive survey" (https://doi.org/10.1007/978-3-031-39800-1_21).
}
\examples{
tree <- ape::read.tree(text="((((,),),(,)),(((,),),(,)));")
colPlaLab(tree)

}
\references{
C. Colijn and G. Plazzotta. A Metric on Phylogenetic Tree Shapes. Systematic Biology, doi: 10.1093/sysbio/syx046.

N. A. Rosenberg. On the Colijn-Plazzotta numbering scheme for unlabeled binary rooted trees. Discrete Applied Mathematics, 2021. doi: 10.1016/j.dam.2020.11.021.
}
\author{
Sophie Kersting, Luise Kuehn
}
