% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{bootstrap}
\alias{bootstrap}
\alias{bootstrap.tna}
\alias{bootstrap.group_tna}
\title{Bootstrap Transition Networks from Sequence Data}
\usage{
bootstrap(x, iter, level, method, threshold, consistency_range)

\method{bootstrap}{tna}(
  x,
  iter = 1000,
  level = 0.05,
  method = "stability",
  threshold,
  consistency_range = c(0.75, 1.25)
)

\method{bootstrap}{group_tna}(
  x,
  iter = 1000,
  level = 0.05,
  method = "stability",
  threshold,
  consistency_range = c(0.75, 1.25)
)
}
\arguments{
\item{x}{A \code{tna} or a \code{group_tna} object created from sequence data.}

\item{iter}{An \code{integer} specifying the number of bootstrap samples to
draw. Defaults to \code{1000}.}

\item{level}{A \code{numeric} value representing the significance level for
hypothesis testing and confidence intervals. Defaults to \code{0.05}.}

\item{method}{A \code{character} string. This argument defines the bootstrap
test statistic. The \code{"stability"} option (the default) compares edge weights
against a range of "consistent" values defined by \code{consistency_range}.
Weights that fall outside this range are considered insignificant. In other
words, an edge is considered significant if its value is within the range
in \code{(1 - level)} * 100\% of the bootstrap samples. The \code{"threshold"} option
instead compares the edge weights against a user-specified \code{threshold} value.}

\item{threshold}{A \code{numeric} value to compare edge weights against.
The default is the 10th percentile of the edge weights. Used only when
\code{method = "threshold"}.}

\item{consistency_range}{A \code{numeric} vector of length 2. Determines how much
the edge weights may deviate (multiplicatively) from their observed values
(below and above) before they are considered insignificant. The default is
\code{c(0.75, 1.25)} which corresponds to a symmetric 25\% deviation range. Used
only when \code{method = "stability"}.}
}
\value{
A \code{tna_bootstrap} object which is a \code{list} containing the
following elements:
\itemize{
\item \code{weights_orig}: The original edge weight \code{matrix}.
\item \code{weights_sig}: The \code{matrix} of significant transitions
(those with estimated p-values below the significance level).
\item \code{weights_mean}: The mean weight \code{matrix} from the bootstrap samples.
\item \code{weights_sd}: The standard deviation \code{matrix} from the bootstrap samples.
\item \code{cr_lower}: The lower bound \code{matrix} of the consistency range for the
edge weights.
\item \code{cr_upper}: The upper bound \code{matrix} of the consistency range for the
edge weights.
\item \code{ci_lower}: The lower bound \code{matrix} of the bootstrap confidence
intervals for the edge weights.
\item \code{ci_upper}: The upper bound \code{matrix} of the bootstrap confidence
intervals for the edge weights.
\item \code{p_values}: The \code{matrix} of estimated p-values for the edge weights.
\item \code{summary}: A \code{data.frame} summarizing the edges, their weights,
p-values, statistical significance, consistency ranges, and
confidence intervals.
}

If \code{x} is a \code{group_tna} object, the output is a \code{group_tna_bootstrap}
object, which is a \code{list} of \code{tna_bootstrap} objects.
}
\description{
Perform bootstrapping on transition networks created from
sequence data stored in a \code{tna} object. Bootstrapped estimates
of edge weights are returned with confidence intervals and significance
testing.
}
\details{
The function first computes the original edge weights for the specified
cluster from the \code{tna} object. It then performs bootstrapping by resampling
the sequence data and recalculating the edge weights for each
bootstrap sample. The mean and standard deviation of the transitions are
computed, and confidence intervals are derived. The function also estimates
p-values for each edge and identifies significant edges based on
the specified significance level. A matrix of significant edges
(those with estimated p-values below the significance level) is generated.
Additional statistics on removed edges (those not considered
significant) are provided.

All results, including the original transition matrix, bootstrapped
estimates, and summary statistics for removed edges, are returned in a
structured list.
}
\examples{
model <- tna(group_regulation)
# Small number of iterations for CRAN
bootstrap(model, iter = 10)

}
\seealso{
Validation functions
\code{\link{deprune}()},
\code{\link{estimate_cs}()},
\code{\link{permutation_test}()},
\code{\link{permutation_test.group_tna}()},
\code{\link{plot.group_tna_bootstrap}()},
\code{\link{plot.group_tna_permutation}()},
\code{\link{plot.group_tna_stability}()},
\code{\link{plot.tna_bootstrap}()},
\code{\link{plot.tna_permutation}()},
\code{\link{plot.tna_stability}()},
\code{\link{print.group_tna_bootstrap}()},
\code{\link{print.group_tna_permutation}()},
\code{\link{print.group_tna_stability}()},
\code{\link{print.summary.group_tna_bootstrap}()},
\code{\link{print.summary.tna_bootstrap}()},
\code{\link{print.tna_bootstrap}()},
\code{\link{print.tna_permutation}()},
\code{\link{print.tna_stability}()},
\code{\link{prune}()},
\code{\link{pruning_details}()},
\code{\link{reprune}()},
\code{\link{summary.group_tna_bootstrap}()},
\code{\link{summary.tna_bootstrap}()}
}
\concept{validation}
