% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_coefficient.R
\name{adjust_or_with_binary}
\alias{adjust_or_with_binary}
\title{Adjust an observed odds ratio with a binary confounder}
\usage{
adjust_or_with_binary(
  effect_observed,
  exposed_confounder_prev,
  unexposed_confounder_prev,
  confounder_outcome_effect,
  verbose = getOption("tipr.verbose", TRUE),
  or_correction = FALSE
)
}
\arguments{
\item{effect_observed}{Numeric positive value. Observed exposure - outcome
odds ratio. This can be the point estimate, lower confidence bound, or
upper confidence bound.}

\item{exposed_confounder_prev}{Numeric between 0 and 1. Estimated prevalence of the
unmeasured confounder in the exposed population}

\item{unexposed_confounder_prev}{Numeric between 0 and 1. Estimated prevalence of the
unmeasured confounder in the unexposed population}

\item{confounder_outcome_effect}{Numeric positive value. Estimated relationship
between the unmeasured confounder and the outcome}

\item{verbose}{Logical. Indicates whether to print informative message.
Default: \code{TRUE}}

\item{or_correction}{Logical. Indicates whether to use a correction factor.
The methods used for this function are based on risk ratios. For rare
outcomes, an odds ratio approximates a risk ratio. For common outcomes,
a correction factor is needed. If you have a common outcome (>15\%),
set this to \code{TRUE}. Default: \code{FALSE}.}
}
\value{
Data frame.
}
\description{
Adjust an observed odds ratio with a binary confounder
}
\examples{
adjust_or_with_binary(3, 1, 0, 3)
adjust_or_with_binary(3, 1, 0, 3, or_correction = TRUE)
}
