% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/follow.R
\name{check_me_following}
\alias{check_me_following}
\title{Check if Current User Follows Artists or Users}
\usage{
check_me_following(type, ids, authorization = get_spotify_authorization_code())
}
\arguments{
\item{type}{Required. String of the ID type: either \code{"artist"} or \code{"user"}.}

\item{ids}{Required. A character vector of the artist or the user \href{https://developer.spotify.com/documentation/web-api/#spotify-uris-and-ids}{Spotify IDs} to check. For example: \code{ids = c("74ASZWbe4lXaubB36ztrGX", "08td7MxkoHQkXnWAYD8d6Q")}. A maximum of 50 IDs can be sent in one request.}

\item{authorization}{Required. A valid access token from the Spotify Accounts service. See the \href{https://developer.spotify.com/documentation/general/guides/authorization-guide/}{Web API authorization Guide} for more details. Defaults to \code{spotifyr::get_spotify_authorization_code()}. The access token must have been issued on behalf of the current user. Getting details of the artists or users the current user follows requires authorization of the \code{user-follow-read} scope. See \href{https://developer.spotify.com/documentation/general/guides/authorization-guide/#list-of-scopes}{Using Scopes}.}
}
\value{
Returns a list of results containing user following status.
}
\description{
Check if Current User Follows Artists or Users
}
