% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R
\name{tidy.C5.0}
\alias{tidy.C5.0}
\title{Get the \link{rulelist} from a \link[C50:C5.0]{C5} model}
\usage{
\method{tidy}{C5.0}(x, ...)
}
\arguments{
\item{x}{\link[C50:C5.0]{C50::C5.0} model fitted with \code{rules = TRUE}}

\item{...}{Other arguments (See details)}
}
\value{
A \link{rulelist} object
}
\description{
Each row corresponds to a rule per \code{trial_nbr}
}
\details{
\itemize{
\item The output columns are: \code{rule_nbr}, \code{trial_nbr}, \code{LHS}, \code{RHS},
\code{support}, \code{confidence}, \code{lift}.
\item Rules per \code{trial_nbr} are sorted in this order: \code{desc(confidence)},
\code{desc(lift)}, \code{desc(support)}.
}

Optional named arguments:
\itemize{
\item \code{laplace} (flag, default: TRUE) is supported. This
computes confidence with laplace correction as documented under 'Rulesets'
here: \href{https://www.rulequest.com/see5-unix.html}{C5 doc}.
}
}
\examples{
model_c5 = C50::C5.0(Attrition ~., data = modeldata::attrition, rules = TRUE)
tidy(model_c5)

}
\seealso{
\link{rulelist}, \link{tidy}, \link[=augment.rulelist]{augment},
\link[=predict.rulelist]{predict}, \link[=calculate.rulelist]{calculate},
\link[=prune.rulelist]{prune}, \link[=reorder.rulelist]{reorder}

Other Core Tidy Utility: 
\code{\link{tidy}()},
\code{\link{tidy.cubist}()},
\code{\link{tidy.rpart}()}
}
\concept{Core Tidy Utility}
