% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-embedding-vectors.R
\name{get_regions}
\alias{get_regions}
\title{Word embedding semantic region extractor}
\usage{
get_regions(wv, k_regions = 5L, max_iter = 20L, seed = 0)
}
\arguments{
\item{wv}{Matrix of word embedding vectors (a.k.a embedding model)
with rows as words.}

\item{k_regions}{Integer indicating the k number of regions to return}

\item{max_iter}{Integer indicating the maximum number of iterations
before k-means terminates.}

\item{seed}{Integer indicating a random seed. Default is 0, which calls
'std::time(NULL)'.}
}
\value{
returns a matrix of class "dgCMatrix" with k rows and d dimensions
}
\description{
Given a set of word embeddings of \eqn{d} dimensions and \eqn{v} vocabulary,
\code{\link[=get_regions]{get_regions()}} finds \eqn{k} semantic regions in \eqn{d} dimensions.
This, in effect, learns latent topics from an embedding space (a.k.a.
topic modeling), which are directly comparable to both terms (with
cosine similarity) and documents (with Concept Mover's distance
using \code{\link[=CMDist]{CMDist()}}).
}
\details{
To group words into more encompassing "semantic regions" we use \eqn{k}-means
clustering. We choose \eqn{k}-means primarily for it's ubiquity and the wide
range of available diagnostic tools for \eqn{k}-means cluster.

A word embedding matrix of \eqn{d} dimensions and \eqn{v} vocabulary is
"clustered" into \eqn{k} semantic regions which have \eqn{d} dimensions.
Each region is represented by a single point defined by the \eqn{d}
dimensional vector. The process discretely assigns all word vectors are
assigned to a given region so as to minimize some error function, however
as the resulting regions are in the same dimensions as the word embeddings,
we can measure each terms similarity to each region. This, in effect,
is a mixed membership topic model similar to topic modeling by Latent
Dirichlet Allocation.

We use the \code{KMeans_arma} function from the \code{ClusterR} package which
uses the Armadillo library.
}
\examples{

# load example word embeddings
data(ft_wv_sample)

my_regions <- get_regions(
  wv = ft_wv_sample,
  k_regions = 10L,
  max_iter = 10L,
  seed = 01984
)
}
\references{
Butnaru, Andrei M., and Radu Tudor Ionescu.  (2017)
'From image to text classification: A novel approach
based on clustering word embeddings.'
\emph{Procedia computer science}. 112:1783-1792.
\doi{10.1016/j.procs.2017.08.211}.\cr
Zhang, Yi, Jie Lu, Feng Liu, Qian Liu, Alan Porter,
Hongshu Chen, and Guangquan Zhang. (2018).
'Does Deep Learning Help Topic Extraction? A Kernel
K-Means Clustering Method with Word Embedding.'
\emph{Journal of Informetrics}. 12(4):1099-1117.
\doi{10.1016/j.joi.2018.09.004}.\cr
Arseniev-Koehler, Alina and Cochran, Susan D and
Mays, Vickie M and Chang, Kai-Wei and Foster,
Jacob Gates (2021) 'Integrating topic modeling
and word embedding to characterize violent deaths'
\doi{10.31235/osf.io/nkyaq}\cr
}
\author{
Dustin Stoltz
}
