% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_generics.R
\name{as_data_frame}
\alias{as_data_frame}
\title{Convert a taxa object to a \code{data.frame}}
\usage{
as_data_frame(
  x,
  row.names = NULL,
  optional = FALSE,
  ...,
  stringsAsFactors = FALSE
)
}
\arguments{
\item{x}{An object defined by taxa, such as \link{taxon} or \link{taxon_id}}

\item{row.names}{\code{NULL} or a character vector giving the row
    names for the data frame.  Missing values are not allowed.}

\item{optional}{logical. If \code{TRUE}, setting row names and
    converting column names (to syntactic names: see
    \code{\link[base]{make.names}}) is optional.  Note that all of \R's
    \pkg{base} package \code{as.data.frame()} methods use
    \code{optional} only for column names treatment, basically with the
    meaning of \code{\link[base]{data.frame}(*, check.names = !optional)}.
    See also the \code{make.names} argument of the \code{matrix} method.}

\item{...}{additional arguments to be passed to or from methods.}

\item{stringsAsFactors}{logical: should the character vector be converted
    to a factor?}
}
\description{
Convert the information in a taxa object to a \code{data.frame} using base R
vectors as columns. Use \code{\link[tibble:as_tibble]{tibble::as_tibble()}} to convert to tibbles.
}
\examples{
x <- taxon(name = c('Homo sapiens', 'Bacillus', 'Ascomycota', 'Ericaceae'),
           rank = c('species', 'genus', 'phylum', 'family'),
           id = taxon_id(c('9606', '1386', '4890', '4345'), db = 'ncbi'),
           auth = c('Linnaeus, 1758', 'Cohn 1872', NA, 'Juss., 1789'))
as_data_frame(x)

}
