% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{timing_trajectory}
\alias{timing_trajectory}
\title{Timing pattern frequency within clusters}
\usage{
timing_trajectory(
  object,
  only = NULL,
  clusters = NULL,
  additional_data = NULL,
  ...
)
}
\arguments{
\item{object}{An object for which a summary is desired.}

\item{only}{<\code{\link[dplyr:dplyr_data_masking]{data-masking}}> Expressions that
return a logical value, and are defined in terms of the variables in
\code{object} and/or \code{additional_data}.

The default \code{NULL} selects all clusterings in \code{object}.}

\item{clusters}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> An unquoted
expression naming the cluster or clusters in \code{object} one wants to
see summaries of. Names can be used as if they were positions in the data
frame, so expressions like I:IV can be used to select a range of clusters.

The default \code{NULL} selects all clusters in the chosen clusterings of
\code{object}.}

\item{additional_data}{A data frame with additional data that may be
(left-)joined onto the \code{parameters} in \code{object}. This is often
used in conjuction with \code{only} to select specific clusterings based on
\code{additional_data}.}

\item{...}{Additional arguments passed to the specific summary sub-function.}
}
\value{
\code{timing_trajectory()} returns a list of class \code{timing_trajectory} with two
data frames:
\subsection{average}{
\itemize{
\item \code{Clustering} the name of the clustering.
\item \code{Cluster} the cluster name.
\item \emph{timing variables} the average timing value in the cluster.
\item \code{Count} the number of people in the cluster.
}
}

\subsection{individual}{
\itemize{
\item \code{Clustering} the name of the clustering.
\item \code{Cluster} the cluster name.
\item \emph{timing variables} unique timing pattern in the cluster.
\item \code{Count} number of people with this unique timing pattern.
}
}
}
\description{
\code{timing_trajectory()} calculates the average timing paths within clusters.
}
\details{
\code{timing_trajectory()} calculates both the number of unique timing
trajectories in each cluster and the average timing trajectories in each
cluster.
}
\examples{
clust <- medic(
  complications,
  id = id,
  atc = atc,
  k = 3:5,
  timing = first_trimester:third_trimester
)

timing_trajectory(clust, k == 5, clusters = I:III)

}
