% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise.R
\name{cat_summarise}
\alias{cat_summarise}
\alias{cat_summarize}
\title{Summarise the values of a numerical variable for each group within a
categorical variable}
\usage{
cat_summarise(
  data,
  cat,
  num,
  na.rm = FALSE,
  clean_names = getOption("tabbycat.clean_names")
)

cat_summarize(
  data,
  cat,
  num,
  na.rm = FALSE,
  clean_names = getOption("tabbycat.clean_names")
)
}
\arguments{
\item{data}{A dataframe containing a categorical variable and numerical
variable to summarise.}

\item{cat}{The name of a column in \code{data} which is a categorical vector
of discrete values for which summaries will be calculated.}

\item{num}{The name of a column in \code{data} which is a numerical vector
that will be summarised for each group.}

\item{na.rm}{A boolean indicating whether to exclude NAs from the row
results. Note that NAs are **always** ignored in calculating the summary
statistics for \code{num} shown in each row, and the number of NAs that
exist in \code{num} for each group in \code{cat} is shown in the
\code{na} column of the results table. This argument controls whether a
row of summary statistics is shown for observations that are NA in
\code{cat}. The default is FALSE.}

\item{clean_names}{A boolean indicating whether the column names of the
results tibble should be cleaned, so that any column names produced from
data are converted to snake_case. The default is TRUE, but this can be
changed with \code{options(tabbycat.clean_names = FALSE)}.}
}
\value{
A tibble showing summary statistics for \code{num} for each group
  in \code{cat}.
}
\description{
The results are sorted on the values of the categorical variable i.e.
the variable specified with \code{cat}. If this variable is a character
vector it will be sorted alphabetically. If it is a factor it will be
sorted in the order of its levels. This function can be called as either
\code{cat_summarise} or \code{cat_summarize}.
}
