% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzz_.R, R/fuzz_functions.R
\name{fuzz_}
\alias{fuzz_}
\alias{fuzzdist}
\alias{fuzz_m_ratio}
\alias{fuzz_partial_ratio}
\alias{fuzz_token_sort_ratio}
\alias{fuzz_token_set_ratio}
\title{Calculate similarity between two strings}
\usage{
fuzzdist(
  a,
  b,
  method = c("fuzz_m_ratio", "fuzz_partial_ratio", "fuzz_token_sort_ratio",
    "fuzz_token_set_ratio")
)

fuzz_m_ratio(a, b)

fuzz_partial_ratio(a, b)

fuzz_token_sort_ratio(a, b)

fuzz_token_set_ratio(a, b)
}
\arguments{
\item{a}{A character vector of items to match to b.}

\item{b}{A character vector of items to match to a.}

\item{method}{The method to use for fuzzy matching.}
}
\value{
Returns a score of same length as b, giving the proportional dissimilarity between a and b.
}
\description{
These functions duplicate the approach of the 'fuzzywuzzy' Python library for calculating string similarity.
}
\note{
\code{fuzz_m_ratio} is a measure of the number of letters that match between two strings. It is calculated as one minus two times the number of matched characters, divided by the number of characters in both strings.

\code{fuzz_partial_ratio} calculates the extent to which one string is a subset of the other. If one string is a perfect subset, then this will be zero.

\code{fuzz_token_sort_ratio} sorts the words in both strings into alphabetical order, and checks their similarity using fuzz_m_ratio.

\code{fuzz_token_set_ratio} is similar to fuzz_token_sort_ratio, but compares both sorted strings to each other, and to a third group made of words common to both strings. It then returns the maximum value of fuzz_m_ratio from these comparisons.

\code{fuzzdist} is a wrapper function, for compatability with \code{stringdist}.
}
\examples{
fuzzdist("On the Origin of Species",
         "Of the Original Specs",
         method = "fuzz_m_ratio")
}
