% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_effects.R
\name{createRandomEffectsTracker}
\alias{createRandomEffectsTracker}
\title{Create RandomEffectsTracker Object}
\usage{
createRandomEffectsTracker(rfx_group_indices)
}
\arguments{
\item{rfx_group_indices}{Integer indices indicating groups used to define random effects}
}
\value{
\code{RandomEffectsTracker} object
}
\description{
Create a \code{RandomEffectsTracker} object

This function is intended for advanced use cases in which users require detailed control of sampling algorithms and data structures.
Minimal input validation and error checks are performed -- users are responsible for providing the correct inputs.
For tutorials on the "proper" usage of the stochtree's advanced workflow, we provide several vignettes at stochtree.ai
}
\examples{
n <- 100
rfx_group_ids <- sample(1:2, size = n, replace = TRUE)
rfx_basis <- matrix(rep(1.0, n), ncol=1)
num_groups <- length(unique(rfx_group_ids))
num_components <- ncol(rfx_basis)
rfx_tracker <- createRandomEffectsTracker(rfx_group_ids)
}
