% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{size.ci.lc.mean.ws}
\alias{size.ci.lc.mean.ws}
\title{Sample size for a within-subjects mean linear contrast confidence interval}
\usage{
size.ci.lc.mean.ws(alpha, var, cor, w, q)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{var}{planning value of average variance of the measurements}

\item{cor}{planning value of average correlation between measurements}

\item{w}{desired confidence interval width}

\item{q}{vector of within-subjects contrast coefficients}
}
\value{
Returns the required sample size
}
\description{
Computes the sample size required to estimate a linear contrast of
population means with desired confidence interval precision in a
within-subjects design. Set the variance planning value to the
largest value within a plausible range for a conservatively large
sample size. Set the Pearson correlation planning value to the
smallest value within a plausible range for a conservatively
large sample size.

For more details, see Section 4.26 of Bonett (2021, Volume 1)
}
\examples{
q <- c(.5, .5, -.5, -.5)
size.ci.lc.mean.ws(.05, 161.9, .77, 4, q)

# Should return:
# Sample size
#          38
 

}
\references{
\insertRef{Bonett2021}{statpsych}
}
