% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{size.ci.ancova2}
\alias{size.ci.ancova2}
\title{Sample size for a 2-group ANCOVA confidence interval}
\usage{
size.ci.ancova2(alpha, evar, s, d, w, R)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{evar}{planning value of within group (error) variance}

\item{s}{number of covariates}

\item{d}{largest standardized mean difference of all covariates}

\item{w}{desired confidence interval width}

\item{R}{ratio of n2/n1}
}
\value{
Returns the required sample size for each group
}
\description{
Computes the sample size for each group required to estimate a mean
difference in a 2-group ANCOVA model with desired confidence interval
precision. In a nonexperimental design, the sample size is affected by
the magnitude of covariate mean differences across groups. The covariate
mean differences can be approximated by specifying the largest
standardized covariate mean difference of all covariates. In an
experiment, this standardized mean difference should be set to 0. Set
the error variance planning value to the largest value within a
plausible range for a conservatively large sample size.

For more details, see Section 2.28 of Bonett (2021, Volume 2)
}
\examples{
size.ci.ancova2(.05, 1.37, 1, 0, 1.5, 1)

# Should return:
#  n1 n2
#  21 21

size.ci.ancova2(.05, 1.37, 1, 0, 1.5, 2)

# Should return:
#  n1 n2
#  16 32

size.ci.ancova2(.05, 1.37, 1, .75, 1.5, 1)

# Should return:
#  n1 n2
#  24 24
 

}
\references{
\insertRef{Bonett2021}{statpsych}
}
