% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.ratio.mad.ps}
\alias{ci.ratio.mad.ps}
\title{Confidence interval for a paired-samples MAD ratio}
\usage{
ci.ratio.mad.ps(alpha, y1, y2)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{y1}{vector of measurement 1 scores}

\item{y2}{vector of measurement 2 scores (paired with y1)}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item MAD1 - estimated MAD for measurement 1
\item MAD2 - estimated MAD for measurement 2
\item MAD1/MAD2 - estimate of MAD ratio
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a confidence interval for a ratio of population MADs (mean absolute
deviation from median) in a paired-samples design.

For more details, see Section 4.24 of Bonett (2021, Volume 1)
}
\examples{
y2 <- c(21, 4, 9, 12, 35, 18, 10, 22, 24, 1, 6, 8, 13, 16, 19)
y1 <- c(67, 28, 30, 28, 52, 40, 25, 37, 44, 10, 14, 20, 28, 40, 51)
ci.ratio.mad.ps(.05, y1, y2)

# Should return:
#     MAD1  MAD2  MAD1/MAD2       LL       UL
# 12.71429   7.5   1.695238 1.109176 2.590961


}
\references{
\insertRef{Bonett2003a}{statpsych}

\insertRef{Bonett2021}{statpsych}
}
