% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gxeAmmi.R
\name{gxeGGE}
\alias{gxeGGE}
\title{GGE analysis}
\usage{
gxeGGE(
  TD,
  trials = names(TD),
  trait,
  nPC = 2,
  byYear = FALSE,
  center = TRUE,
  excludeGeno = NULL,
  useWt = FALSE
)
}
\arguments{
\item{TD}{An object of class \code{\link[statgenSTA]{TD}}.}

\item{trials}{A character string specifying the trials to be analyzed. If
not supplied, all trials are used in the analysis.}

\item{trait}{A character string specifying the trait to be analyzed.}

\item{nPC}{An integer specifying the number of principal components used
as multiplicative term of genotype-by-trial interaction. If \code{NULL}, the
number of principal components is determined by the algorithm using
forward selection. See details.}

\item{byYear}{Should the analysis be done by year? If \code{TRUE} the data
is split by the variable year, analysis is performed and the results are
merged together and returned.}

\item{center}{Should the variables be shifted to be zero centered?}

\item{excludeGeno}{An optional character vector with names of genotypes to
be excluded from the analysis. If \code{NULL}, all genotypes are used.}

\item{useWt}{Should weighting be used when modeling? Requires a column
\code{wt} in \code{TD}.}
}
\description{
The Genotype plus Genotype by Environment interaction (GGE) model fits
a model with trial as main fixed effect. Then a principal component
analysis is done on the residuals. This results in an interaction
characterized by Interaction Principal Components (IPCA)
enabling simultaneous plotting of genotypes and trials.\cr\cr
The parameter \code{nPC} is used to indicate the number of principal
components that is used in the principal component analysis (PCA). By setting
this parameter to \code{NULL} the algorithm determines the best number of
principal components (see Details).\cr\cr
By specifying the parameter \code{byYear = TRUE}, a separate analysis will be
done for every year in the data. Combining the option with \code{nPC = NULL}
may result in different numbers of principal components per year. The GGE
estimates will still be returned as a single data.frame, but the other
results will be either lists or arrays.
}
\details{
First a linear model \eqn{trait = trial + \epsilon} is fitted with trial a
fixed component in the model.\cr
The residuals from the fitted model are then used in a PCA. If \code{nPC} is
not \code{NULL} a single PCA is done using \code{\link[stats]{prcomp}} with
maximum rank \code{nPC}.\cr
In case \code{nPC = NULL}, the PCA is first done with one PC. Then using
forward selection one by one the number of PCs is increased as long as the
added component is significant in the analysis.\cr
GGE estimates are then computed using the results of the PCA.\cr
}
