% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ht_2pop_prop.R
\name{ht_2pop_prop}
\alias{ht_2pop_prop}
\title{Hypothesis testing for two population porportions}
\usage{
ht_2pop_prop(
  x,
  y,
  n_x = NULL,
  n_y = NULL,
  delta = 0,
  alternative = "two.sided",
  conf_level = NULL,
  sig_level = 0.05,
  na_rm = FALSE
)
}
\arguments{
\item{x}{a vector of 0 and 1, or a scalar of count of sucesses in the first group.}

\item{y}{a vector of 0 and 1, or a scalar of count of sucesses in the first group.}

\item{n_x}{a scalar of number of trials in the first group.}

\item{n_y}{a scalar of number of trials in the second group.}

\item{delta}{a scalar value indicating the difference in proportions (\eqn{\Delta_0}). Default value is 0.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of "two.sided" (default), "greater" or "less".}

\item{conf_level}{a number indicating the confidence level to compute the confidence interval. If \code{conf_level = NULL}, then the confidence interval is not included in the output. Default value is \code{NULL}.}

\item{sig_level}{a number indicating the significance level to use in the General Procedure for Hypothesis Testing.}

\item{na_rm}{a logical value indicating whether \code{NA} values should be removed before the computation proceeds. Default value is \code{FALSE}.}
}
\value{
a \code{tibble} with the following columns:
\describe{
\item{statistic}{the value of the test statistic.}
\item{p_value}{the p-value for the test.}
\item{critical_value}{critical value in the General Procedure for Hypothesis Testing.}
\item{critical_region}{critical region in the General Procedure for Hypothesis Testing.}
\item{delta}{a scalar value indicating the value of \code{delta}.}
\item{alternative}{character string giving the direction of the alternative hypothesis.}
\item{lower_ci}{lower bound of the confidence interval. It is presented only if \code{!is.null(conf_level)}.}
\item{upper_ci}{upper bound of the confidence interval. It is presented only if \code{!is.null(conf_level)}.}
}
}
\description{
Comparing proportions in two populations
}
\details{
\code{ht_2pop_prop} can be used for testing the null hipothesis that proportions (probabilities of success) in two groups are the same.

If \code{is.null(n_x) == T} and \code{is.null(n_y) == T}, then \code{x} and \code{y} must be a numeric value of 0 and 1 and the proportions are computed using \code{x} and \code{y}. If \code{is.null(n_x) == F} and \code{is.null(n_y) == F}, then  \code{x}, \code{y}, \code{n_x} and \code{n_y} must be non-negative integer scalars and \code{x <= n_x} and \code{y <= n_y}.
}
\examples{
x <- 3
n_x <- 100
y <- 50
n_y <- 333
ht_2pop_prop(x, y, n_x, n_y)

x <- rbinom(100, 1, 0.75)
y <- rbinom(500, 1, 0.75)
ht_2pop_prop(x, y)
}
