% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_power_nbinom.R
\name{sim_power_nbinom}
\alias{sim_power_nbinom}
\title{Empirical Power for Negative Binomial Comparison}
\usage{
sim_power_nbinom(
  n1,
  n2,
  ir1,
  tm,
  rr,
  boundary,
  dispersion,
  alpha,
  nsim,
  conf.level = 0.95
)
}
\arguments{
\item{n1}{Integer. Number of participants in group 1.}

\item{n2}{Integer. Number of participants in group 2.}

\item{ir1}{Numeric. Incidence rate in group 1.}

\item{tm}{Numeric. Average exposure time per subject (assumed equal across subjects).}

\item{rr}{Numeric. True relative risk between groups (group 2 rate = rr × group 1 rate).}

\item{boundary}{Numeric. Relative risk boundary under the null hypothesis.}

\item{dispersion}{Numeric. Dispersion parameter (\eqn{\phi}) for the negative binomial distribution.}

\item{alpha}{Numeric. Type I error rate (two-sided).}

\item{nsim}{Integer. Number of simulation iterations.}

\item{conf.level}{Numeric. Confidence level for the empirical power estimate}
}
\value{
An S3 object of class \code{empirical_power_result}, which contains
the estimated empirical power and its confidence interval. The object can
be printed, formatted, or further processed using associated S3 methods.
See also \code{\link{empirical_power_result}}.
}
\description{
Estimates empirical power to detect a relative risk either above or below a specified boundary,
depending on the direction of the alternative hypothesis. Simulates count data with over dispersion,
fits a model with \code{glm.nb}, and evaluates the power to reject the null
hypothesis using a negative binomial model.
}
\note{
Uses the alternative parameterization of the negative binomial: \code{mu} is the mean,
and \code{size = 1/dispersion}. In \code{glm.nb}, dispersion is estimated as \code{theta}.
The 'boundary' parameter defines the relative risk under the null hypothesis. When rr < 1,
rejection occurs if the upper limit of the confidence interval is below the boundary.
When rr > 1, rejection occurs if the lower limit is above the boundary.

The \code{alpha} parameter is two-sided as it is used to estimate two-sided confidence intervals
}
\examples{
\donttest{
sim_power_nbinom(
 n1 = 150, n2 = 150,
 ir1 = 0.55, tm = 1.7,
 rr = 0.6, boundary = 1,
 dispersion = 2,
 alpha = 0.05,
 nsim = 1000
)
}
}
\seealso{
\code{\link{empirical_power_result}}
}
\author{
Chris Gast

John J. Aponte
}
