% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_power_best_binomial.R
\name{sim_power_best_binomial}
\alias{sim_power_best_binomial}
\title{Simulate Power to Select the Best Group Using Binomial Outcomes}
\usage{
sim_power_best_binomial(
  noutcomes,
  p1,
  dif,
  ngroups,
  npergroup,
  nsim,
  conf.level = 0.95
)
}
\arguments{
\item{noutcomes}{Integer. Number of outcomes to evaluate.}

\item{p1}{Numeric. Probability in the most promising group (scalar or vector).}

\item{dif}{Numeric. Difference between the best group and the rest.}

\item{ngroups}{Integer. Number of groups.}

\item{npergroup}{Integer or vector. Number of subjects per group.}

\item{nsim}{Integer. Number of simulations.}

\item{conf.level}{Numeric. Confidence level for the empirical power estimate}
}
\value{
An S3 object of class \code{empirical_power_result}, which contains
the estimated empirical power and its confidence interval. The object can
be printed, formatted, or further processed using associated S3 methods.
See also \code{\link{empirical_power_result}}.
}
\description{
Estimates the empirical power to correctly identify the best group as having
the highest outcome, under a binomial distribution. Assumes that the most
promising group has a higher success probability than the others by at least
\code{dif}, and that outcomes are independent.
}
\details{
Multiple outcomes can be evaluated simultaneously. The power is estimated as
the proportion of simulations where the most promising group is selected best
in all outcomes.
}
\examples{
sim_power_best_binomial(
  noutcomes = 1,
  p1 = 0.7,
  dif = 0.2,
  ngroups = 3,
  npergroup = 30,
  nsim = 1000
)
}
\seealso{
\code{\link{empirical_power_result}}
}
