% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multz.R
\name{multp}
\alias{multp}
\title{Calculate the Multivariate Normal Probability}
\usage{
multp(q, k, rho, seed = NULL)
}
\arguments{
\item{q}{Numeric. Quantile of the distribution.}

\item{k}{Integer. Number of variables in the multivariate normal distribution.
Must be >= 1.}

\item{rho}{Numeric. Common correlation coefficient between variables (typically
between 0 and 1).}

\item{seed}{Optional. An object specifying if and how the random number generator
should be initialized. Passed to \code{\link[mvtnorm]{pmvnorm}}.}
}
\value{
Numeric. The multivariate probability
}
\description{
Computes the multivariate normal probabilities with arbitrary correlation matrices
It is the inverse of the \code{multz} function
}
\examples{
q <- 1.3      
k <- 3        
rho <- 0.5    
multp(q, k, rho)

}
