% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssimparser.R
\name{load_ssim_flights}
\alias{load_ssim_flights}
\title{load_ssim_flights}
\usage{
load_ssim_flights(
  ssim_files = c("AFR_20201115.txt", "AFR_20201116.txt"),
  collist = get_ssim_collist(getall = FALSE),
  clean_col_names = TRUE
)
}
\arguments{
\item{ssim_files}{List of SSIM files to load, in the correct order (from the first to load to the last file to load).}

\item{collist}{List of columns that need to be present in the final Data Frame. get_ssim_collist() to get the full list.}

\item{clean_col_names}{Clean column names in the final Data Frame by removing type2/type3 prefixes (TRUE/FALSE). Default TRUE.}
}
\value{
Data Frame containing the flights.
}
\description{
Load multiple SSIM file, expand to flights, and return the result as a Data Frame. \cr
In case of period overlap for a specific flight date, information from the latest file will be used, \cr
so beware of the file order in
parameter ssim_files.
}
\examples{
# Get 3 samples as a character vector
samples <- data.frame(sampleid = c(1:3)) \%>\%
 dplyr::rowwise() \%>\%
 dplyr::mutate(
 filename = tempfile(),
 samplestring = ssimparser::get_ssim_sample(datefrom = as.Date("2020-11-01") + (sampleid * 3),
 dateto = as.Date("2020-12-01") + (sampleid * 3),
 season = "W20",
 creadate = as.Date("2020-11-01") + sampleid)
 )
# Write the samples to tempdir
for (i in 1:3)
{
 write(samples[i,]$samplestring, samples[i,]$filename, append = FALSE)
}

# Load the 3 samples and display the total traffic per day
ssimparser::load_ssim_flights(ssim_files = samples$filename) \%>\%
dplyr::group_by(flight_date = as.Date(flight.flight_date)) \%>\%
dplyr::summarise(total_flights = dplyr::n()) \%>\%
dplyr::arrange(desc(flight_date))

# Unlink temp files
for (i in 1:3)
{
  unlink(samples[i,]$filename)
}
}
