% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkDNA.R
\name{checkDNA}
\alias{checkDNA}
\title{Check a DNA alignment for missing data}
\usage{
checkDNA(DNAbin, gapsAsMissing = TRUE)
}
\arguments{
\item{DNAbin}{A DNA alignment of class `DNAbin'.}

\item{gapsAsMissing}{Logical. Should gaps (coded as '-') be considered
missing bases? Default of TRUE.}
}
\value{
A numeric vector giving the number of missing bases in each sequence
of the alignment.
}
\description{
This functions counts the number of bases in an alignment that are composed
of missing data.
}
\details{
This function considers bases coded as '?' and 'N' as missing data. By
default, gaps (coded as '-') are also considered missing.
}
\examples{

data(anoteropsis)
checkDNA(anoteropsis)
checkDNA(anoteropsis, gapsAsMissing=FALSE)

}
\author{
Samuel Brown <s_d_j_brown@hotmail.com>
}
\keyword{Utilities}
