% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chaoHaplo.R
\name{chaoHaplo}
\alias{chaoHaplo}
\title{Chao estimator of haplotype number}
\usage{
chaoHaplo(DNAbin)
}
\arguments{
\item{DNAbin}{An object of class `DNAbin'.}
}
\value{
An vector of length three, giving the estimated total number of
haplotypes in the population, and lower and upper 95\% confidence limits.
}
\description{
Calculates the Chao1 estimate of the number of haplotypes in a population
based on the total number of haplotypes present, and the number of
singletons and doubletons in the dataset.
}
\details{
The function assumes a large number of specimens have been sampled and that
duplicate haplotypes have not been removed. Interpretation becomes difficult
when more than one species is included in the dataset.
}
\examples{

data(dolomedes)
#Create dataset with multiple copies of Dolomedes haplotypes
doloSamp <- dolomedes[sample(16, 100, replace=TRUE, prob=c(0.85, rep(0.01, 15))), ]

chaoHaplo(doloSamp)

}
\references{
Vink, C. J., McNeill, M. R., Winder, L. M., Kean, J. M., and
Phillips, C. B. (2011). PCR analyses of gut contents of pasture arthropods.
In: Paddock to PCR: Demystifying Molecular Technologies for Practical Plant
Protection (eds. Ridgway, H. J., Glare, T. R., Wakelin, S. A., O'Callaghan,
M.), pp. 125-134. New Zealand Plant Protection Society, Lincoln.

Chao, A. (1989). Estimating population size for sparse data in
capture-recapture experiments. _Biometrics_ *45* 427-438.
}
\seealso{
\code{\link{haploAccum}}
}
\author{
Samuel Brown <s_d_j_brown@hotmail.com>
}
\keyword{Barcoding}
