% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec.R
\name{\%matches\%.data.frame}
\alias{\%matches\%.data.frame}
\alias{matches}
\title{Check Whether Data Frame matches Spec}
\usage{
\method{\%matches\%}{data.frame}(x, y, ...)
}
\arguments{
\item{x}{spec}

\item{y}{coerced to spec (spec object or filepath for spec file).}

\item{...}{passed arguments}
}
\value{
logical; TRUE if all checks above are enforceable.
}
\description{
Checks whether data.frame matches spec.  Column names, count, and order are enforced. Encodings are enforced (all non-missing values must be valid codes).  Integer and numeric ranges are enforced. Values of \code{required} are parsed and evaluated in data context: Where TRUE, the corresponding data value for \code{column} cannot be missing.
}
\examples{
data(drug)
file <- tempfile()
spec <- specification(drug, tol = 3)
write.spec(spec, file = file)
drug \%matches\% spec
}
\seealso{
Other matches: 
\code{\link{\%matches\%.character}()},
\code{\link{\%matches\%.spec}()},
\code{\link{\%matches\%}()}
}
\concept{matches}
