% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annulus.matrix.R
\name{annulus.matrix}
\alias{annulus.matrix}
\title{Annulus matrix}
\usage{
annulus.matrix(scale = 3, inner.scale = 0, outer.scale = 0, null.value = 0)
}
\arguments{
\item{scale}{Number of rings (defines dimensions of matrix)}

\item{inner.scale}{Number of inner rings to set to null.value}

\item{outer.scale}{Number of outer rings to set to null.value}

\item{null.value}{Value to set inner and outer scale(s) to}
}
\value{
A matrix object with defined null.value and 1, representing retained rings
}
\description{
Creates a square matrix representing annulus position values of 1 
             and defined null
}
\details{
This function will return a matrix of 1 and defined null.value based on a specification
of the scale, inner scale and outer scale. The scale defines how many rings will be
represented in the matrix based on (2 * scale - 1). So, a scale of 3 will result in a
5x5 matrix. The inner.scale and outer.scale arguments represent the > and < rings that
will be set to the defined null.value (see examples). The resulting matrix can be used
as the specified window in a focal function.
}
\examples{
annulus.matrix(5)                   # 5 concentric rings
annulus.matrix(5, 3)                # 5 concentric rings with the 3 inner set to 0
annulus.matrix(5, 3, null.value=NA) # 5 concentric rings with the 3 inner set to NA
annulus.matrix(5, 3, 5)             # 5 rings with 3 inner and 5 outer set to 0
annulus.matrix(9, 3, 7)             # 9 rings with 3 inner and 7 outer set to 0

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
