% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simitation.R
\name{sim.prop.test}
\alias{sim.prop.test}
\title{sim.prop.test}
\usage{
sim.prop.test(
  simdat.prop,
  p = NULL,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95,
  correct = TRUE,
  experiment.name = "experiment",
  value.name = "x"
)
}
\arguments{
\item{simdat.prop}{Data for use in one-sample proportions tests across one or more experiments.  Structure is in the form returned by the function simitation::sim.prop().}

\item{p}{See help(prop.test).}

\item{alternative}{See help(prop.test).}

\item{conf.level}{See help(prop.test).}

\item{correct}{See help(prop.test).}

\item{experiment.name}{A character value providing the name of the column identifying the experiment.}

\item{value.name}{A character value providing the name of the column identifying the values.}
}
\value{
A data.table containing test statistics for each experiment based on the one-sample proportions test. Columns typically include experiment name, statistic, p-value, and other relevant metrics as returned by the internal testing function.
}
\description{
sim.prop.test
}
\examples{

simdat.prop <- sim.prop(n = 30, p = 0.45, num.experiments = 2,
experiment.name = "simulation_id", value.name = "success", seed = 104)

test.statistics.prop <- sim.prop.test(simdat.prop = simdat.prop, p = 0.5,
 alternative = "two.sided", conf.level = 0.99, correct = TRUE,
 experiment.name = "simulation_id", value.name = "success")

}
