% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simitation.R
\name{internal.t2.test}
\alias{internal.t2.test}
\title{Internal function for Two-sample t-test}
\usage{
internal.t2.test(
  x,
  y,
  alternative = c("two.sided", "less", "greater"),
  mu = 0,
  paired = FALSE,
  var.equal = FALSE,
  conf.level = 0.95
)
}
\arguments{
\item{x}{First numeric vector.}

\item{y}{Second numeric vector.}

\item{alternative}{A character string specifying the alternative hypothesis. One of \code{"two.sided"}, \code{"less"}, or \code{"greater"}. Default is \code{"two.sided"}.}

\item{mu}{A number indicating the true value of the mean difference (relevant if \code{paired = TRUE}). Default is 0.}

\item{paired}{A logical indicating whether you want a paired t-test. Default is FALSE.}

\item{var.equal}{A logical variable indicating whether to treat the two variances as being equal. If TRUE then the pooled variance is used to estimate the variance otherwise the Welch (or Satterthwaite) approximation to the degrees of freedom is used. Default is FALSE.}

\item{conf.level}{A numeric value between 0 and 1 indicating the confidence level for the interval estimate of the mean difference. Default is 0.95.}
}
\value{
A data frame with test results.
}
\description{
Computes the two-sample t-test for the given data.
}
