% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_do_pedigree.R
\name{sim_do_pedigree}
\alias{sim_do_pedigree}
\title{Simulate a pedigree for Diversity Outbred mice}
\usage{
sim_do_pedigree(
  ngen = 12,
  npairs = 144,
  ccgen = rep(4:12, c(21, 64, 24, 10, 5, 9, 5, 3, 3)),
  nkids_per = 5,
  design = c("nosib", "random")
)
}
\arguments{
\item{ngen}{Number of generations of outbreeding}

\item{npairs}{Number of breeding pairs at each generation}

\item{ccgen}{Vector of length \code{npairs}, with the number of
generations for each CC line. If length 1, it is repeated to a
vector of length \code{npairs}.}

\item{nkids_per}{Number of offspring per pair for the last
generation}

\item{design}{How to choose crosses: either random but avoiding
siblings, or completely at random}
}
\value{
A data frame with six columns: individual ID, mother ID, father
ID, sex, generation, and TRUE/FALSE indicator for whether DO or pre-DO.
Founders have \code{0} for mother and father ID. Sex is coded 0 for
female and 1 for male.
}
\description{
Simulate a pedigree for generating Diversity Outbred (DO) mice (a
table of individual, mom, dad, sex).
}
\details{
Diversity outbred (DO) mice are generated from a set of 8 inbred
lines. We need two individuals from each line (one female and one
male) as the order of the initial crosses will be randomized; for
example, sometimes the individual from line 1 will be a mother and
sometimes a father. The founders are numbered 1-8 for the females
from the 8 lines, and 9-16 for the corresponding males.

Diversity Outbred mice are generated by first creating a panel of
partially-inbred 8-way RIL (the so-called pre-CC, for
pre-Collaborative Cross). The \code{ccgen} argument specifies the
number of inbreeding generations for each of the CC lines. We
generate a pre-CC line for each of the \code{npairs} breeding
pairs, and generate a sibling pair from each as the starting
material.

The subsequent \code{ngen} outbreeding generations then proceed by
crossing a male and female from the preceding generation (mated
completely at random, with \code{design="random"}, or avoiding
siblings, with \code{design="nosib"}). Each breeding pair gives a
single female and a single male to the next generation, except at
the last generation \code{nkids_per} offspring are mated, in equal
numbers male and female. (If \code{nkids_per} is an odd number, the
number of males and females in each sibship will differ by one,
alternating between sibships, with one additional female and then
one additional male.

The default for \code{ccgen} is taken from Figure 1 of Svenson et
al. (2012).
}
\examples{
tab <- sim_do_pedigree(8)
}
\references{
Svenson KL, Gatti DM, Valdar W, Welsh CE, Cheng R, Chesler EJ,
Palmer AA, McMillan L, Churchill GA (2012) High-resolution genetic
mapping using the mouse Diversity Outbred population. Genetics
190:437-447
}
\seealso{
\code{\link[=sim_from_pedigree]{sim_from_pedigree()}},
\code{\link[=sim_ril_pedigree]{sim_ril_pedigree()}}, \code{\link[=sim_ail_pedigree]{sim_ail_pedigree()}},
\code{\link[=sim_4way_pedigree]{sim_4way_pedigree()}}
}
\keyword{datagen}
