% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils__state.R
\name{state_store_get_remove}
\alias{state_store_get_remove}
\title{Fetch and remove the single-use state entry}
\usage{
state_store_get_remove(client, state, shiny_session = NULL)
}
\arguments{
\item{client}{\link{OAuthClient} instance}

\item{state}{Plain (decrypted) state string used as the logical key}

\item{shiny_session}{Optional pre-captured Shiny session context (from
\code{capture_shiny_session_context()}) to include in audit events. Used when
calling from async workers that lack access to the reactive domain.}
}
\value{
A list with \code{browser_token}, \code{pkce_code_verifier}, and \code{nonce}.
Throws an error via \code{err_invalid_state()} if retrieval or removal fails,
or if the retrieved value is missing/malformed.
}
\description{
Retrieves the state-bound values from the client's \code{state_store} and removes
the entry to enforce single-use semantics.
}
\details{
When the store exposes an atomic \verb{$take(key, missing)} method (see
\code{\link[=custom_cache]{custom_cache()}}), it is used preferentially to guarantee single-use even
under concurrent access in shared/distributed backends.
When \verb{$take()} is not available, the function falls back to
\verb{$get()} + \verb{$remove()} with a post-removal absence check.
This fallback is safe for per-process caches (e.g., \code{\link[cachem:cache_mem]{cachem::cache_mem()}})
but \strong{errors} for any other store (e.g., \code{\link[cachem:cache_disk]{cachem::cache_disk()}} or custom
backends) because non-atomic get+remove cannot guarantee single-use under
concurrent access. Shared stores \strong{must} implement \verb{$take()} to be used
as a state store.
}
\keyword{internal}
