% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/doc.R
\name{progress}
\alias{progress}
\title{progress}
\usage{
progress(...)
}
\arguments{
\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}
}
\value{
An object of class \code{shiny.tag} containing the
necessary configuration and including options such as JavaScript
dependencies to instantiate a HeroUI progress component.
}
\description{
The Progress component allows you to view the progress of any activity.
}
\details{
\itemize{
\item \bold{label}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{size}. Type: \code{sm OR md OR lg}. Default: \code{"md"}.
\item \bold{color}. Type: \code{default OR primary OR secondary OR success OR warning OR danger}. Default: \code{"primary"}.
\item \bold{radius}. Type: \code{none OR sm OR md OR lg OR full}. Default: \code{"full"}.
\item \bold{value}. Type: \code{number}. Default: \code{NA}.
\item \bold{valueLabel}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{minValue}. Type: \code{number}. Default: \code{"0"}.
\item \bold{maxValue}. Type: \code{number}. Default: \code{"100"}.
\item \bold{formatOptions}. Type: \code{Intl.NumberFormat}. Default: \code{"{style: 'percent'}"}.
\item \bold{isIndeterminate}. Type: \code{boolean}. Default: \code{false}.
\item \bold{isStriped}. Type: \code{boolean}. Default: \code{false}.
\item \bold{showValueLabel}. Type: \code{boolean}. Default: \code{true}.
\item \bold{isDisabled}. Type: \code{boolean}. Default: \code{false}.
\item \bold{disableAnimation}. Type: \code{boolean}. Default: \code{false}.
\item \bold{classNames}. Type: \code{Partial<Record<'base' OR 'labelWrapper' OR 'label' OR 'track' OR 'value' OR 'indicator', string>>}. Default: \code{NA}.
}
}
\examples{
library(shiny)
library(shinyNextUI)

colors <- c(
  "default",
  "primary",
  "secondary",
  "success",
  "warning",
  "danger"
)

bool_par <- c(rep(FALSE, 3), rep(TRUE, 2), FALSE)

progress_config <- data.frame(
  label = c(rep("A label", 3), rep("", 3)),
  show_value_label = c(rep(FALSE, 3), rep(TRUE, 3)),
  size = c("sm", "sm", rep("md", 2), "lg", "lg"),
  color = colors,
  striped = bool_par,
  radius = c(rep("none", 2), "sm", "md", "lg", "full")
)

progress_factory <- function(
  label,
  show_value_label,
  size,
  color,
  striped,
  radius
) {
  progress(
    label = label,
    showValueLabel = show_value_label,
    value = round(runif(1, 0, 100)),
    size = size,
    color = color,
    isStriped = striped,
    radius = radius
  )
}

progresses <- purrr::pmap(progress_config, progress_factory)

ui <- nextui_page(
  div(
    class = "grid gap-4 grid-cols-3 grid-rows-3 m-5",
    progresses
  )
)

server <- function(input, output, session) {
}

if (interactive() || is_testing()) shinyApp(ui, server)
}
\seealso{
See \url{https://heroui.com/docs/components/progress}.
}
