% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jdate.R
\name{jdate}
\alias{jdate}
\alias{jdate.numeric}
\alias{jdate.character}
\title{Jalali calendar dates}
\usage{
jdate(x, ...)

\method{jdate}{numeric}(x, ...)

\method{jdate}{character}(x, format = NULL, ...)
}
\arguments{
\item{x}{A vector of numeric or character objects.}

\item{...}{Arguments passed on to further methods.}

\item{format}{Format argument for character method.}
}
\value{
A vector of \code{jdate} objects.
}
\description{
\code{jdate} is an S3 class for representing the Jalali calendar dates. It can be constructed
from character and numeric vectors.
}
\details{
\code{jdate} is stored internaly as a double vector and doesn't have any attributes.
Its value represents the count of days since the Unix epoch (a negative value
if it represents a date prior to the epoch). This implementation coincides
with the implementation of \code{Date} class.
}
\examples{
jdate("1402-09-20")
jdate("1402/09/20", format = "\%Y/\%m/\%d")
## Will replace invalid date format with NA
jdate("1402/09/20", format = "\%Y-\%m-\%d")
## Invalid dates will be replaced with NA
jdate("1402-12-30")
## Jalali date corresponding to "1970-01-01"
jdate(0)

}
