% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sigma_attrs.R
\name{add_edge_color}
\alias{add_edge_color}
\title{Modify the edge colors of a sgraph object.}
\usage{
add_edge_color(
  sigma_obj,
  one_color = NULL,
  color_attr = NULL,
  color_palette = "Set2"
)
}
\arguments{
\item{sigma_obj}{sgraph object}

\item{one_color}{A single color to color all of the nodes (hex format)}

\item{color_attr}{The name of an edge attribute}

\item{color_palette}{Name of RColorBrewer palette to use}
}
\value{
sgraph with modified edge colors
}
\description{
Modify the edge colors of a sgraph object by providing a single color.
Also works with a vector of correct size.
}
\examples{
library(igraph)
library(sgraph)

data(lesMis)

sig <- sigma_from_igraph(igraph = lesMis) \%>\%
  add_edge_color(one_color = "#ccc")
sig

}
