% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.R
\name{set.control.cv}
\alias{set.control.cv}
\title{Check and set the cross-validation parameters}
\usage{
set.control.cv(
  criterion = c("dev", "mae", "mse", "aic", "bic"),
  refit = TRUE,
  nfolds = 5,
  proportion = 0.3,
  init = c("common", "separate"),
  verbose = FALSE,
  parallel = FALSE,
  nthreads = 1
)
}
\arguments{
\item{criterion}{information criterion to minimize for selecting the matrix rank}

\item{refit}{if \code{TRUE}, refit the model with the selected rank and return the fitted model}

\item{nfolds}{number of cross-validation folds}

\item{proportion}{proportion of the data to be used as test set in each fold}

\item{init}{initialization approach to use}

\item{verbose}{if \code{TRUE}, print the cross-validation status}

\item{parallel}{if \code{TRUE}, allows for parallel computing}

\item{nthreads}{number of cores to use in parallel (only if \code{parallel=TRUE})}
}
\value{
A \code{list} of control parameters for the cross-validation algorithm
}
\description{
Check if the input cross-validation parameters are allowed and set them to default
values if they are not. Returns a list of well-defined cross-validation parameters.
}
\examples{
library(sgdGMF)

# Empty call
set.control.cv()

# Parametrized call
set.control.cv(criterion = "bic", proportion = 0.2)

}
\seealso{
\code{\link{set.control.init}}, \code{\link{set.control.alg}}, \code{\link{sgdgmf.cv}}
}
